package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HostPortRangeBuilder extends HostPortRangeFluentImpl<HostPortRangeBuilder> implements VisitableBuilder<HostPortRange,HostPortRangeBuilder>{
  public HostPortRangeBuilder() {
    this(false);
  }
  public HostPortRangeBuilder(Boolean validationEnabled) {
    this(new HostPortRange(), validationEnabled);
  }
  public HostPortRangeBuilder(HostPortRangeFluent<?> fluent) {
    this(fluent, false);
  }
  public HostPortRangeBuilder(HostPortRangeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HostPortRange(), validationEnabled);
  }
  public HostPortRangeBuilder(HostPortRangeFluent<?> fluent,HostPortRange instance) {
    this(fluent, instance, false);
  }
  public HostPortRangeBuilder(HostPortRangeFluent<?> fluent,HostPortRange instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMax(instance.getMax()); 
    fluent.withMin(instance.getMin()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HostPortRangeBuilder(HostPortRange instance) {
    this(instance,false);
  }
  public HostPortRangeBuilder(HostPortRange instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMax(instance.getMax()); 
    this.withMin(instance.getMin()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HostPortRangeFluent<?> fluent;
  Boolean validationEnabled;
  public HostPortRange build() {
    HostPortRange buildable = new HostPortRange(fluent.getMax(),fluent.getMin());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}