package io.fabric8.kubernetes.api.model.policy.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RuntimeClassStrategyOptionsFluent<A extends RuntimeClassStrategyOptionsFluent<A>> extends BaseFluent<A>{
  public RuntimeClassStrategyOptionsFluent() {
  }
  
  public RuntimeClassStrategyOptionsFluent(RuntimeClassStrategyOptions instance) {
    this.copyInstance(instance);
  }
  private List<String> allowedRuntimeClassNames = new ArrayList<String>();
  private String defaultRuntimeClassName;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RuntimeClassStrategyOptions instance) {
    instance = (instance != null ? instance : new RuntimeClassStrategyOptions());
    if (instance != null) {
          this.withAllowedRuntimeClassNames(instance.getAllowedRuntimeClassNames());
          this.withDefaultRuntimeClassName(instance.getDefaultRuntimeClassName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAllowedRuntimeClassNames(int index,String item) {
    if (this.allowedRuntimeClassNames == null) {this.allowedRuntimeClassNames = new ArrayList<String>();}
    this.allowedRuntimeClassNames.add(index, item);
    return (A)this;
  }
  
  public A setToAllowedRuntimeClassNames(int index,String item) {
    if (this.allowedRuntimeClassNames == null) {this.allowedRuntimeClassNames = new ArrayList<String>();}
    this.allowedRuntimeClassNames.set(index, item); return (A)this;
  }
  
  public A addToAllowedRuntimeClassNames(java.lang.String... items) {
    if (this.allowedRuntimeClassNames == null) {this.allowedRuntimeClassNames = new ArrayList<String>();}
    for (String item : items) {this.allowedRuntimeClassNames.add(item);} return (A)this;
  }
  
  public A addAllToAllowedRuntimeClassNames(Collection<String> items) {
    if (this.allowedRuntimeClassNames == null) {this.allowedRuntimeClassNames = new ArrayList<String>();}
    for (String item : items) {this.allowedRuntimeClassNames.add(item);} return (A)this;
  }
  
  public A removeFromAllowedRuntimeClassNames(java.lang.String... items) {
    if (this.allowedRuntimeClassNames == null) return (A)this;
    for (String item : items) { this.allowedRuntimeClassNames.remove(item);} return (A)this;
  }
  
  public A removeAllFromAllowedRuntimeClassNames(Collection<String> items) {
    if (this.allowedRuntimeClassNames == null) return (A)this;
    for (String item : items) { this.allowedRuntimeClassNames.remove(item);} return (A)this;
  }
  
  public List<String> getAllowedRuntimeClassNames() {
    return this.allowedRuntimeClassNames;
  }
  
  public String getAllowedRuntimeClassName(int index) {
    return this.allowedRuntimeClassNames.get(index);
  }
  
  public String getFirstAllowedRuntimeClassName() {
    return this.allowedRuntimeClassNames.get(0);
  }
  
  public String getLastAllowedRuntimeClassName() {
    return this.allowedRuntimeClassNames.get(allowedRuntimeClassNames.size() - 1);
  }
  
  public String getMatchingAllowedRuntimeClassName(Predicate<String> predicate) {
      for (String item : allowedRuntimeClassNames) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAllowedRuntimeClassName(Predicate<String> predicate) {
      for (String item : allowedRuntimeClassNames) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAllowedRuntimeClassNames(List<String> allowedRuntimeClassNames) {
    if (allowedRuntimeClassNames != null) {
        this.allowedRuntimeClassNames = new ArrayList();
        for (String item : allowedRuntimeClassNames) {
          this.addToAllowedRuntimeClassNames(item);
        }
    } else {
      this.allowedRuntimeClassNames = null;
    }
    return (A) this;
  }
  
  public A withAllowedRuntimeClassNames(java.lang.String... allowedRuntimeClassNames) {
    if (this.allowedRuntimeClassNames != null) {
        this.allowedRuntimeClassNames.clear();
        _visitables.remove("allowedRuntimeClassNames");
    }
    if (allowedRuntimeClassNames != null) {
      for (String item : allowedRuntimeClassNames) {
        this.addToAllowedRuntimeClassNames(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAllowedRuntimeClassNames() {
    return this.allowedRuntimeClassNames != null && !this.allowedRuntimeClassNames.isEmpty();
  }
  
  public String getDefaultRuntimeClassName() {
    return this.defaultRuntimeClassName;
  }
  
  public A withDefaultRuntimeClassName(String defaultRuntimeClassName) {
    this.defaultRuntimeClassName = defaultRuntimeClassName;
    return (A) this;
  }
  
  public boolean hasDefaultRuntimeClassName() {
    return this.defaultRuntimeClassName != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RuntimeClassStrategyOptionsFluent that = (RuntimeClassStrategyOptionsFluent) o;
    if (!java.util.Objects.equals(allowedRuntimeClassNames, that.allowedRuntimeClassNames)) return false;
    if (!java.util.Objects.equals(defaultRuntimeClassName, that.defaultRuntimeClassName)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(allowedRuntimeClassNames,  defaultRuntimeClassName,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowedRuntimeClassNames != null && !allowedRuntimeClassNames.isEmpty()) { sb.append("allowedRuntimeClassNames:"); sb.append(allowedRuntimeClassNames + ","); }
    if (defaultRuntimeClassName != null) { sb.append("defaultRuntimeClassName:"); sb.append(defaultRuntimeClassName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}