package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RoleRefBuilder extends RoleRefFluent<RoleRefBuilder> implements VisitableBuilder<RoleRef,RoleRefBuilder>{
  public RoleRefBuilder() {
    this(new RoleRef());
  }
  
  public RoleRefBuilder(RoleRefFluent<?> fluent) {
    this(fluent, new RoleRef());
  }
  
  public RoleRefBuilder(RoleRefFluent<?> fluent,RoleRef instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RoleRefBuilder(RoleRef instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RoleRefFluent<?> fluent;
  
  public RoleRef build() {
    RoleRef buildable = new RoleRef(fluent.getApiGroup(),fluent.getKind(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}