package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CSIDriverSpecBuilder extends CSIDriverSpecFluentImpl<CSIDriverSpecBuilder> implements VisitableBuilder<CSIDriverSpec,CSIDriverSpecBuilder>{
  public CSIDriverSpecBuilder() {
    this(false);
  }
  public CSIDriverSpecBuilder(Boolean validationEnabled) {
    this(new CSIDriverSpec(), validationEnabled);
  }
  public CSIDriverSpecBuilder(CSIDriverSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CSIDriverSpecBuilder(CSIDriverSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CSIDriverSpec(), validationEnabled);
  }
  public CSIDriverSpecBuilder(CSIDriverSpecFluent<?> fluent,CSIDriverSpec instance) {
    this(fluent, instance, false);
  }
  public CSIDriverSpecBuilder(CSIDriverSpecFluent<?> fluent,CSIDriverSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAttachRequired(instance.getAttachRequired()); 
    fluent.withFsGroupPolicy(instance.getFsGroupPolicy()); 
    fluent.withPodInfoOnMount(instance.getPodInfoOnMount()); 
    fluent.withRequiresRepublish(instance.getRequiresRepublish()); 
    fluent.withStorageCapacity(instance.getStorageCapacity()); 
    fluent.withTokenRequests(instance.getTokenRequests()); 
    fluent.withVolumeLifecycleModes(instance.getVolumeLifecycleModes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CSIDriverSpecBuilder(CSIDriverSpec instance) {
    this(instance,false);
  }
  public CSIDriverSpecBuilder(CSIDriverSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAttachRequired(instance.getAttachRequired()); 
    this.withFsGroupPolicy(instance.getFsGroupPolicy()); 
    this.withPodInfoOnMount(instance.getPodInfoOnMount()); 
    this.withRequiresRepublish(instance.getRequiresRepublish()); 
    this.withStorageCapacity(instance.getStorageCapacity()); 
    this.withTokenRequests(instance.getTokenRequests()); 
    this.withVolumeLifecycleModes(instance.getVolumeLifecycleModes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CSIDriverSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CSIDriverSpec build() {
    CSIDriverSpec buildable = new CSIDriverSpec(fluent.getAttachRequired(),fluent.getFsGroupPolicy(),fluent.getPodInfoOnMount(),fluent.getRequiresRepublish(),fluent.getStorageCapacity(),fluent.getTokenRequests(),fluent.getVolumeLifecycleModes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}