package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageClassBuilder extends StorageClassFluentImpl<StorageClassBuilder> implements VisitableBuilder<StorageClass,StorageClassBuilder>{
  public StorageClassBuilder() {
    this(false);
  }
  public StorageClassBuilder(Boolean validationEnabled) {
    this(new StorageClass(), validationEnabled);
  }
  public StorageClassBuilder(StorageClassFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageClassBuilder(StorageClassFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageClass(), validationEnabled);
  }
  public StorageClassBuilder(StorageClassFluent<?> fluent,StorageClass instance) {
    this(fluent, instance, false);
  }
  public StorageClassBuilder(StorageClassFluent<?> fluent,StorageClass instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllowVolumeExpansion(instance.getAllowVolumeExpansion()); 
    fluent.withAllowedTopologies(instance.getAllowedTopologies()); 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withMountOptions(instance.getMountOptions()); 
    fluent.withParameters(instance.getParameters()); 
    fluent.withProvisioner(instance.getProvisioner()); 
    fluent.withReclaimPolicy(instance.getReclaimPolicy()); 
    fluent.withVolumeBindingMode(instance.getVolumeBindingMode()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StorageClassBuilder(StorageClass instance) {
    this(instance,false);
  }
  public StorageClassBuilder(StorageClass instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllowVolumeExpansion(instance.getAllowVolumeExpansion()); 
    this.withAllowedTopologies(instance.getAllowedTopologies()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withMountOptions(instance.getMountOptions()); 
    this.withParameters(instance.getParameters()); 
    this.withProvisioner(instance.getProvisioner()); 
    this.withReclaimPolicy(instance.getReclaimPolicy()); 
    this.withVolumeBindingMode(instance.getVolumeBindingMode()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  StorageClassFluent<?> fluent;
  Boolean validationEnabled;
  public StorageClass build() {
    StorageClass buildable = new StorageClass(fluent.getAllowVolumeExpansion(),fluent.getAllowedTopologies(),fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getMountOptions(),fluent.getParameters(),fluent.getProvisioner(),fluent.getReclaimPolicy(),fluent.getVolumeBindingMode());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}