/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Application;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationFluent;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationFluentImpl;
import java.util.Objects;

public class ApplicationBuilder
extends ApplicationFluentImpl<ApplicationBuilder>
implements VisitableBuilder<Application, ApplicationBuilder> {
    ApplicationFluent<?> fluent;
    Boolean validationEnabled;

    public ApplicationBuilder() {
        this(false);
    }

    public ApplicationBuilder(Boolean validationEnabled) {
        this(new Application(), validationEnabled);
    }

    public ApplicationBuilder(ApplicationFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ApplicationBuilder(ApplicationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Application(), validationEnabled);
    }

    public ApplicationBuilder(ApplicationFluent<?> fluent, Application instance) {
        this(fluent, instance, false);
    }

    public ApplicationBuilder(ApplicationFluent<?> fluent, Application instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ApplicationBuilder(Application instance) {
        this(instance, (Boolean)false);
    }

    public ApplicationBuilder(Application instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public Application build() {
        Application buildable = new Application(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApplicationBuilder that = (ApplicationBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

