/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ContactData;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ContactDataBuilder;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ContactDataFluentImpl;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Descriptor;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.DescriptorFluent;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ImageSpec;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ImageSpecBuilder;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ImageSpecFluentImpl;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Link;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.LinkBuilder;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.LinkFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class DescriptorFluentImpl<A extends DescriptorFluent<A>>
extends BaseFluent<A>
implements DescriptorFluent<A> {
    private String description;
    private ArrayList<ImageSpecBuilder> icons = new ArrayList();
    private List<String> keywords = new ArrayList<String>();
    private ArrayList<LinkBuilder> links = new ArrayList();
    private ArrayList<ContactDataBuilder> maintainers = new ArrayList();
    private String notes;
    private ArrayList<ContactDataBuilder> owners = new ArrayList();
    private String type;
    private String version;

    public DescriptorFluentImpl() {
    }

    public DescriptorFluentImpl(Descriptor instance) {
        this.withDescription(instance.getDescription());
        this.withIcons(instance.getIcons());
        this.withKeywords(instance.getKeywords());
        this.withLinks(instance.getLinks());
        this.withMaintainers(instance.getMaintainers());
        this.withNotes(instance.getNotes());
        this.withOwners(instance.getOwners());
        this.withType(instance.getType());
        this.withVersion(instance.getVersion());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    @Override
    public Boolean hasDescription() {
        return this.description != null;
    }

    @Override
    public A addToIcons(Integer index, ImageSpec item) {
        if (this.icons == null) {
            this.icons = new ArrayList();
        }
        ImageSpecBuilder builder = new ImageSpecBuilder(item);
        this._visitables.get((Object)"icons").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"icons").size(), builder);
        this.icons.add(index >= 0 ? index.intValue() : this.icons.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIcons(Integer index, ImageSpec item) {
        if (this.icons == null) {
            this.icons = new ArrayList();
        }
        ImageSpecBuilder builder = new ImageSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"icons").size()) {
            this._visitables.get((Object)"icons").add(builder);
        } else {
            this._visitables.get((Object)"icons").set(index, builder);
        }
        if (index < 0 || index >= this.icons.size()) {
            this.icons.add(builder);
        } else {
            this.icons.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIcons(ImageSpec ... items) {
        if (this.icons == null) {
            this.icons = new ArrayList();
        }
        for (ImageSpec item : items) {
            ImageSpecBuilder builder = new ImageSpecBuilder(item);
            this._visitables.get((Object)"icons").add(builder);
            this.icons.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIcons(Collection<ImageSpec> items) {
        if (this.icons == null) {
            this.icons = new ArrayList();
        }
        for (ImageSpec item : items) {
            ImageSpecBuilder builder = new ImageSpecBuilder(item);
            this._visitables.get((Object)"icons").add(builder);
            this.icons.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIcons(ImageSpec ... items) {
        for (ImageSpec item : items) {
            ImageSpecBuilder builder = new ImageSpecBuilder(item);
            this._visitables.get((Object)"icons").remove(builder);
            if (this.icons == null) continue;
            this.icons.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIcons(Collection<ImageSpec> items) {
        for (ImageSpec item : items) {
            ImageSpecBuilder builder = new ImageSpecBuilder(item);
            this._visitables.get((Object)"icons").remove(builder);
            if (this.icons == null) continue;
            this.icons.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromIcons(Predicate<ImageSpecBuilder> predicate) {
        if (this.icons == null) {
            return (A)this;
        }
        Iterator<ImageSpecBuilder> each = this.icons.iterator();
        List visitables = this._visitables.get((Object)"icons");
        while (each.hasNext()) {
            ImageSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageSpec> getIcons() {
        return this.icons != null ? DescriptorFluentImpl.build(this.icons) : null;
    }

    @Override
    public List<ImageSpec> buildIcons() {
        return this.icons != null ? DescriptorFluentImpl.build(this.icons) : null;
    }

    @Override
    public ImageSpec buildIcon(Integer index) {
        return this.icons.get(index).build();
    }

    @Override
    public ImageSpec buildFirstIcon() {
        return this.icons.get(0).build();
    }

    @Override
    public ImageSpec buildLastIcon() {
        return this.icons.get(this.icons.size() - 1).build();
    }

    @Override
    public ImageSpec buildMatchingIcon(Predicate<ImageSpecBuilder> predicate) {
        for (ImageSpecBuilder item : this.icons) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIcon(Predicate<ImageSpecBuilder> predicate) {
        for (ImageSpecBuilder item : this.icons) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIcons(List<ImageSpec> icons) {
        if (this.icons != null) {
            this._visitables.get((Object)"icons").removeAll(this.icons);
        }
        if (icons != null) {
            this.icons = new ArrayList();
            for (ImageSpec item : icons) {
                this.addToIcons(item);
            }
        } else {
            this.icons = null;
        }
        return (A)this;
    }

    @Override
    public A withIcons(ImageSpec ... icons) {
        if (this.icons != null) {
            this.icons.clear();
        }
        if (icons != null) {
            for (ImageSpec item : icons) {
                this.addToIcons(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIcons() {
        return this.icons != null && !this.icons.isEmpty();
    }

    @Override
    public A addNewIcon(String size, String src, String type) {
        return this.addToIcons(new ImageSpec(size, src, type));
    }

    @Override
    public DescriptorFluent.IconsNested<A> addNewIcon() {
        return new IconsNestedImpl();
    }

    @Override
    public DescriptorFluent.IconsNested<A> addNewIconLike(ImageSpec item) {
        return new IconsNestedImpl(-1, item);
    }

    @Override
    public DescriptorFluent.IconsNested<A> setNewIconLike(Integer index, ImageSpec item) {
        return new IconsNestedImpl(index, item);
    }

    @Override
    public DescriptorFluent.IconsNested<A> editIcon(Integer index) {
        if (this.icons.size() <= index) {
            throw new RuntimeException("Can't edit icons. Index exceeds size.");
        }
        return this.setNewIconLike(index, this.buildIcon(index));
    }

    @Override
    public DescriptorFluent.IconsNested<A> editFirstIcon() {
        if (this.icons.size() == 0) {
            throw new RuntimeException("Can't edit first icons. The list is empty.");
        }
        return this.setNewIconLike(0, this.buildIcon(0));
    }

    @Override
    public DescriptorFluent.IconsNested<A> editLastIcon() {
        int index = this.icons.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last icons. The list is empty.");
        }
        return this.setNewIconLike(index, this.buildIcon(index));
    }

    @Override
    public DescriptorFluent.IconsNested<A> editMatchingIcon(Predicate<ImageSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.icons.size(); ++i) {
            if (!predicate.test(this.icons.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching icons. No match found.");
        }
        return this.setNewIconLike(index, this.buildIcon(index));
    }

    @Override
    public A addToKeywords(Integer index, String item) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(index, item);
        return (A)this;
    }

    @Override
    public A setToKeywords(Integer index, String item) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.set(index, item);
        return (A)this;
    }

    @Override
    public A addToKeywords(String ... items) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        for (String item : items) {
            this.keywords.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToKeywords(Collection<String> items) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        for (String item : items) {
            this.keywords.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromKeywords(String ... items) {
        for (String item : items) {
            if (this.keywords == null) continue;
            this.keywords.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromKeywords(Collection<String> items) {
        for (String item : items) {
            if (this.keywords == null) continue;
            this.keywords.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getKeywords() {
        return this.keywords;
    }

    @Override
    public String getKeyword(Integer index) {
        return this.keywords.get(index);
    }

    @Override
    public String getFirstKeyword() {
        return this.keywords.get(0);
    }

    @Override
    public String getLastKeyword() {
        return this.keywords.get(this.keywords.size() - 1);
    }

    @Override
    public String getMatchingKeyword(Predicate<String> predicate) {
        for (String item : this.keywords) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingKeyword(Predicate<String> predicate) {
        for (String item : this.keywords) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withKeywords(List<String> keywords) {
        if (keywords != null) {
            this.keywords = new ArrayList<String>();
            for (String item : keywords) {
                this.addToKeywords(item);
            }
        } else {
            this.keywords = null;
        }
        return (A)this;
    }

    @Override
    public A withKeywords(String ... keywords) {
        if (this.keywords != null) {
            this.keywords.clear();
        }
        if (keywords != null) {
            for (String item : keywords) {
                this.addToKeywords(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasKeywords() {
        return this.keywords != null && !this.keywords.isEmpty();
    }

    @Override
    public A addToLinks(Integer index, Link item) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        LinkBuilder builder = new LinkBuilder(item);
        this._visitables.get((Object)"links").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"links").size(), builder);
        this.links.add(index >= 0 ? index.intValue() : this.links.size(), builder);
        return (A)this;
    }

    @Override
    public A setToLinks(Integer index, Link item) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        LinkBuilder builder = new LinkBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"links").size()) {
            this._visitables.get((Object)"links").add(builder);
        } else {
            this._visitables.get((Object)"links").set(index, builder);
        }
        if (index < 0 || index >= this.links.size()) {
            this.links.add(builder);
        } else {
            this.links.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToLinks(Link ... items) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.get((Object)"links").add(builder);
            this.links.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToLinks(Collection<Link> items) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.get((Object)"links").add(builder);
            this.links.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromLinks(Link ... items) {
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.get((Object)"links").remove(builder);
            if (this.links == null) continue;
            this.links.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLinks(Collection<Link> items) {
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.get((Object)"links").remove(builder);
            if (this.links == null) continue;
            this.links.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromLinks(Predicate<LinkBuilder> predicate) {
        if (this.links == null) {
            return (A)this;
        }
        Iterator<LinkBuilder> each = this.links.iterator();
        List visitables = this._visitables.get((Object)"links");
        while (each.hasNext()) {
            LinkBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Link> getLinks() {
        return this.links != null ? DescriptorFluentImpl.build(this.links) : null;
    }

    @Override
    public List<Link> buildLinks() {
        return this.links != null ? DescriptorFluentImpl.build(this.links) : null;
    }

    @Override
    public Link buildLink(Integer index) {
        return this.links.get(index).build();
    }

    @Override
    public Link buildFirstLink() {
        return this.links.get(0).build();
    }

    @Override
    public Link buildLastLink() {
        return this.links.get(this.links.size() - 1).build();
    }

    @Override
    public Link buildMatchingLink(Predicate<LinkBuilder> predicate) {
        for (LinkBuilder item : this.links) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLink(Predicate<LinkBuilder> predicate) {
        for (LinkBuilder item : this.links) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withLinks(List<Link> links) {
        if (this.links != null) {
            this._visitables.get((Object)"links").removeAll(this.links);
        }
        if (links != null) {
            this.links = new ArrayList();
            for (Link item : links) {
                this.addToLinks(item);
            }
        } else {
            this.links = null;
        }
        return (A)this;
    }

    @Override
    public A withLinks(Link ... links) {
        if (this.links != null) {
            this.links.clear();
        }
        if (links != null) {
            for (Link item : links) {
                this.addToLinks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLinks() {
        return this.links != null && !this.links.isEmpty();
    }

    @Override
    public A addNewLink(String description, String url) {
        return this.addToLinks(new Link(description, url));
    }

    @Override
    public DescriptorFluent.LinksNested<A> addNewLink() {
        return new LinksNestedImpl();
    }

    @Override
    public DescriptorFluent.LinksNested<A> addNewLinkLike(Link item) {
        return new LinksNestedImpl(-1, item);
    }

    @Override
    public DescriptorFluent.LinksNested<A> setNewLinkLike(Integer index, Link item) {
        return new LinksNestedImpl(index, item);
    }

    @Override
    public DescriptorFluent.LinksNested<A> editLink(Integer index) {
        if (this.links.size() <= index) {
            throw new RuntimeException("Can't edit links. Index exceeds size.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    @Override
    public DescriptorFluent.LinksNested<A> editFirstLink() {
        if (this.links.size() == 0) {
            throw new RuntimeException("Can't edit first links. The list is empty.");
        }
        return this.setNewLinkLike(0, this.buildLink(0));
    }

    @Override
    public DescriptorFluent.LinksNested<A> editLastLink() {
        int index = this.links.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last links. The list is empty.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    @Override
    public DescriptorFluent.LinksNested<A> editMatchingLink(Predicate<LinkBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.links.size(); ++i) {
            if (!predicate.test(this.links.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching links. No match found.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    @Override
    public A addToMaintainers(Integer index, ContactData item) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        ContactDataBuilder builder = new ContactDataBuilder(item);
        this._visitables.get((Object)"maintainers").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"maintainers").size(), builder);
        this.maintainers.add(index >= 0 ? index.intValue() : this.maintainers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMaintainers(Integer index, ContactData item) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        ContactDataBuilder builder = new ContactDataBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"maintainers").size()) {
            this._visitables.get((Object)"maintainers").add(builder);
        } else {
            this._visitables.get((Object)"maintainers").set(index, builder);
        }
        if (index < 0 || index >= this.maintainers.size()) {
            this.maintainers.add(builder);
        } else {
            this.maintainers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMaintainers(ContactData ... items) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        for (ContactData item : items) {
            ContactDataBuilder builder = new ContactDataBuilder(item);
            this._visitables.get((Object)"maintainers").add(builder);
            this.maintainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMaintainers(Collection<ContactData> items) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        for (ContactData item : items) {
            ContactDataBuilder builder = new ContactDataBuilder(item);
            this._visitables.get((Object)"maintainers").add(builder);
            this.maintainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMaintainers(ContactData ... items) {
        for (ContactData item : items) {
            ContactDataBuilder builder = new ContactDataBuilder(item);
            this._visitables.get((Object)"maintainers").remove(builder);
            if (this.maintainers == null) continue;
            this.maintainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMaintainers(Collection<ContactData> items) {
        for (ContactData item : items) {
            ContactDataBuilder builder = new ContactDataBuilder(item);
            this._visitables.get((Object)"maintainers").remove(builder);
            if (this.maintainers == null) continue;
            this.maintainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMaintainers(Predicate<ContactDataBuilder> predicate) {
        if (this.maintainers == null) {
            return (A)this;
        }
        Iterator<ContactDataBuilder> each = this.maintainers.iterator();
        List visitables = this._visitables.get((Object)"maintainers");
        while (each.hasNext()) {
            ContactDataBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContactData> getMaintainers() {
        return this.maintainers != null ? DescriptorFluentImpl.build(this.maintainers) : null;
    }

    @Override
    public List<ContactData> buildMaintainers() {
        return this.maintainers != null ? DescriptorFluentImpl.build(this.maintainers) : null;
    }

    @Override
    public ContactData buildMaintainer(Integer index) {
        return this.maintainers.get(index).build();
    }

    @Override
    public ContactData buildFirstMaintainer() {
        return this.maintainers.get(0).build();
    }

    @Override
    public ContactData buildLastMaintainer() {
        return this.maintainers.get(this.maintainers.size() - 1).build();
    }

    @Override
    public ContactData buildMatchingMaintainer(Predicate<ContactDataBuilder> predicate) {
        for (ContactDataBuilder item : this.maintainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMaintainer(Predicate<ContactDataBuilder> predicate) {
        for (ContactDataBuilder item : this.maintainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMaintainers(List<ContactData> maintainers) {
        if (this.maintainers != null) {
            this._visitables.get((Object)"maintainers").removeAll(this.maintainers);
        }
        if (maintainers != null) {
            this.maintainers = new ArrayList();
            for (ContactData item : maintainers) {
                this.addToMaintainers(item);
            }
        } else {
            this.maintainers = null;
        }
        return (A)this;
    }

    @Override
    public A withMaintainers(ContactData ... maintainers) {
        if (this.maintainers != null) {
            this.maintainers.clear();
        }
        if (maintainers != null) {
            for (ContactData item : maintainers) {
                this.addToMaintainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMaintainers() {
        return this.maintainers != null && !this.maintainers.isEmpty();
    }

    @Override
    public A addNewMaintainer(String email, String name, String url) {
        return this.addToMaintainers(new ContactData(email, name, url));
    }

    @Override
    public DescriptorFluent.MaintainersNested<A> addNewMaintainer() {
        return new MaintainersNestedImpl();
    }

    @Override
    public DescriptorFluent.MaintainersNested<A> addNewMaintainerLike(ContactData item) {
        return new MaintainersNestedImpl(-1, item);
    }

    @Override
    public DescriptorFluent.MaintainersNested<A> setNewMaintainerLike(Integer index, ContactData item) {
        return new MaintainersNestedImpl(index, item);
    }

    @Override
    public DescriptorFluent.MaintainersNested<A> editMaintainer(Integer index) {
        if (this.maintainers.size() <= index) {
            throw new RuntimeException("Can't edit maintainers. Index exceeds size.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    @Override
    public DescriptorFluent.MaintainersNested<A> editFirstMaintainer() {
        if (this.maintainers.size() == 0) {
            throw new RuntimeException("Can't edit first maintainers. The list is empty.");
        }
        return this.setNewMaintainerLike(0, this.buildMaintainer(0));
    }

    @Override
    public DescriptorFluent.MaintainersNested<A> editLastMaintainer() {
        int index = this.maintainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last maintainers. The list is empty.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    @Override
    public DescriptorFluent.MaintainersNested<A> editMatchingMaintainer(Predicate<ContactDataBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.maintainers.size(); ++i) {
            if (!predicate.test(this.maintainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching maintainers. No match found.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public A withNotes(String notes) {
        this.notes = notes;
        return (A)this;
    }

    @Override
    public Boolean hasNotes() {
        return this.notes != null;
    }

    @Override
    public A addToOwners(Integer index, ContactData item) {
        if (this.owners == null) {
            this.owners = new ArrayList();
        }
        ContactDataBuilder builder = new ContactDataBuilder(item);
        this._visitables.get((Object)"owners").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"owners").size(), builder);
        this.owners.add(index >= 0 ? index.intValue() : this.owners.size(), builder);
        return (A)this;
    }

    @Override
    public A setToOwners(Integer index, ContactData item) {
        if (this.owners == null) {
            this.owners = new ArrayList();
        }
        ContactDataBuilder builder = new ContactDataBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"owners").size()) {
            this._visitables.get((Object)"owners").add(builder);
        } else {
            this._visitables.get((Object)"owners").set(index, builder);
        }
        if (index < 0 || index >= this.owners.size()) {
            this.owners.add(builder);
        } else {
            this.owners.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToOwners(ContactData ... items) {
        if (this.owners == null) {
            this.owners = new ArrayList();
        }
        for (ContactData item : items) {
            ContactDataBuilder builder = new ContactDataBuilder(item);
            this._visitables.get((Object)"owners").add(builder);
            this.owners.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToOwners(Collection<ContactData> items) {
        if (this.owners == null) {
            this.owners = new ArrayList();
        }
        for (ContactData item : items) {
            ContactDataBuilder builder = new ContactDataBuilder(item);
            this._visitables.get((Object)"owners").add(builder);
            this.owners.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromOwners(ContactData ... items) {
        for (ContactData item : items) {
            ContactDataBuilder builder = new ContactDataBuilder(item);
            this._visitables.get((Object)"owners").remove(builder);
            if (this.owners == null) continue;
            this.owners.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOwners(Collection<ContactData> items) {
        for (ContactData item : items) {
            ContactDataBuilder builder = new ContactDataBuilder(item);
            this._visitables.get((Object)"owners").remove(builder);
            if (this.owners == null) continue;
            this.owners.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromOwners(Predicate<ContactDataBuilder> predicate) {
        if (this.owners == null) {
            return (A)this;
        }
        Iterator<ContactDataBuilder> each = this.owners.iterator();
        List visitables = this._visitables.get((Object)"owners");
        while (each.hasNext()) {
            ContactDataBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContactData> getOwners() {
        return this.owners != null ? DescriptorFluentImpl.build(this.owners) : null;
    }

    @Override
    public List<ContactData> buildOwners() {
        return this.owners != null ? DescriptorFluentImpl.build(this.owners) : null;
    }

    @Override
    public ContactData buildOwner(Integer index) {
        return this.owners.get(index).build();
    }

    @Override
    public ContactData buildFirstOwner() {
        return this.owners.get(0).build();
    }

    @Override
    public ContactData buildLastOwner() {
        return this.owners.get(this.owners.size() - 1).build();
    }

    @Override
    public ContactData buildMatchingOwner(Predicate<ContactDataBuilder> predicate) {
        for (ContactDataBuilder item : this.owners) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOwner(Predicate<ContactDataBuilder> predicate) {
        for (ContactDataBuilder item : this.owners) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOwners(List<ContactData> owners) {
        if (this.owners != null) {
            this._visitables.get((Object)"owners").removeAll(this.owners);
        }
        if (owners != null) {
            this.owners = new ArrayList();
            for (ContactData item : owners) {
                this.addToOwners(item);
            }
        } else {
            this.owners = null;
        }
        return (A)this;
    }

    @Override
    public A withOwners(ContactData ... owners) {
        if (this.owners != null) {
            this.owners.clear();
        }
        if (owners != null) {
            for (ContactData item : owners) {
                this.addToOwners(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOwners() {
        return this.owners != null && !this.owners.isEmpty();
    }

    @Override
    public A addNewOwner(String email, String name, String url) {
        return this.addToOwners(new ContactData(email, name, url));
    }

    @Override
    public DescriptorFluent.OwnersNested<A> addNewOwner() {
        return new OwnersNestedImpl();
    }

    @Override
    public DescriptorFluent.OwnersNested<A> addNewOwnerLike(ContactData item) {
        return new OwnersNestedImpl(-1, item);
    }

    @Override
    public DescriptorFluent.OwnersNested<A> setNewOwnerLike(Integer index, ContactData item) {
        return new OwnersNestedImpl(index, item);
    }

    @Override
    public DescriptorFluent.OwnersNested<A> editOwner(Integer index) {
        if (this.owners.size() <= index) {
            throw new RuntimeException("Can't edit owners. Index exceeds size.");
        }
        return this.setNewOwnerLike(index, this.buildOwner(index));
    }

    @Override
    public DescriptorFluent.OwnersNested<A> editFirstOwner() {
        if (this.owners.size() == 0) {
            throw new RuntimeException("Can't edit first owners. The list is empty.");
        }
        return this.setNewOwnerLike(0, this.buildOwner(0));
    }

    @Override
    public DescriptorFluent.OwnersNested<A> editLastOwner() {
        int index = this.owners.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last owners. The list is empty.");
        }
        return this.setNewOwnerLike(index, this.buildOwner(index));
    }

    @Override
    public DescriptorFluent.OwnersNested<A> editMatchingOwner(Predicate<ContactDataBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.owners.size(); ++i) {
            if (!predicate.test(this.owners.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching owners. No match found.");
        }
        return this.setNewOwnerLike(index, this.buildOwner(index));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescriptorFluentImpl that = (DescriptorFluentImpl)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.icons != null ? !this.icons.equals(that.icons) : that.icons != null) {
            return false;
        }
        if (this.keywords != null ? !this.keywords.equals(that.keywords) : that.keywords != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (this.maintainers != null ? !this.maintainers.equals(that.maintainers) : that.maintainers != null) {
            return false;
        }
        if (this.notes != null ? !this.notes.equals(that.notes) : that.notes != null) {
            return false;
        }
        if (this.owners != null ? !this.owners.equals(that.owners) : that.owners != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.icons, this.keywords, this.links, this.maintainers, this.notes, this.owners, this.type, this.version, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.icons != null && !this.icons.isEmpty()) {
            sb.append("icons:");
            sb.append(this.icons + ",");
        }
        if (this.keywords != null && !this.keywords.isEmpty()) {
            sb.append("keywords:");
            sb.append(this.keywords + ",");
        }
        if (this.links != null && !this.links.isEmpty()) {
            sb.append("links:");
            sb.append(this.links + ",");
        }
        if (this.maintainers != null && !this.maintainers.isEmpty()) {
            sb.append("maintainers:");
            sb.append(this.maintainers + ",");
        }
        if (this.notes != null) {
            sb.append("notes:");
            sb.append(this.notes + ",");
        }
        if (this.owners != null && !this.owners.isEmpty()) {
            sb.append("owners:");
            sb.append(this.owners + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
        }
        sb.append("}");
        return sb.toString();
    }

    class OwnersNestedImpl<N>
    extends ContactDataFluentImpl<DescriptorFluent.OwnersNested<N>>
    implements DescriptorFluent.OwnersNested<N>,
    Nested<N> {
        ContactDataBuilder builder;
        Integer index;

        OwnersNestedImpl(Integer index, ContactData item) {
            this.index = index;
            this.builder = new ContactDataBuilder(this, item);
        }

        OwnersNestedImpl() {
            this.index = -1;
            this.builder = new ContactDataBuilder(this);
        }

        @Override
        public N and() {
            return (N)DescriptorFluentImpl.this.setToOwners(this.index, this.builder.build());
        }

        @Override
        public N endOwner() {
            return this.and();
        }
    }

    class MaintainersNestedImpl<N>
    extends ContactDataFluentImpl<DescriptorFluent.MaintainersNested<N>>
    implements DescriptorFluent.MaintainersNested<N>,
    Nested<N> {
        ContactDataBuilder builder;
        Integer index;

        MaintainersNestedImpl(Integer index, ContactData item) {
            this.index = index;
            this.builder = new ContactDataBuilder(this, item);
        }

        MaintainersNestedImpl() {
            this.index = -1;
            this.builder = new ContactDataBuilder(this);
        }

        @Override
        public N and() {
            return (N)DescriptorFluentImpl.this.setToMaintainers(this.index, this.builder.build());
        }

        @Override
        public N endMaintainer() {
            return this.and();
        }
    }

    class LinksNestedImpl<N>
    extends LinkFluentImpl<DescriptorFluent.LinksNested<N>>
    implements DescriptorFluent.LinksNested<N>,
    Nested<N> {
        LinkBuilder builder;
        Integer index;

        LinksNestedImpl(Integer index, Link item) {
            this.index = index;
            this.builder = new LinkBuilder(this, item);
        }

        LinksNestedImpl() {
            this.index = -1;
            this.builder = new LinkBuilder(this);
        }

        @Override
        public N and() {
            return (N)DescriptorFluentImpl.this.setToLinks(this.index, this.builder.build());
        }

        @Override
        public N endLink() {
            return this.and();
        }
    }

    class IconsNestedImpl<N>
    extends ImageSpecFluentImpl<DescriptorFluent.IconsNested<N>>
    implements DescriptorFluent.IconsNested<N>,
    Nested<N> {
        ImageSpecBuilder builder;
        Integer index;

        IconsNestedImpl(Integer index, ImageSpec item) {
            this.index = index;
            this.builder = new ImageSpecBuilder(this, item);
        }

        IconsNestedImpl() {
            this.index = -1;
            this.builder = new ImageSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)DescriptorFluentImpl.this.setToIcons(this.index, this.builder.build());
        }

        @Override
        public N endIcon() {
            return this.and();
        }
    }
}

