/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ClientConfig;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ClientConfigBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ClientConfigFluentImpl;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpec;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ManagedClusterSpecFluentImpl<A extends ManagedClusterSpecFluent<A>>
extends BaseFluent<A>
implements ManagedClusterSpecFluent<A> {
    private Boolean hubAcceptsClient;
    private Integer leaseDurationSeconds;
    private List<ClientConfigBuilder> managedClusterClientConfigs;

    public ManagedClusterSpecFluentImpl() {
    }

    public ManagedClusterSpecFluentImpl(ManagedClusterSpec instance) {
        this.withHubAcceptsClient(instance.getHubAcceptsClient());
        this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds());
        this.withManagedClusterClientConfigs(instance.getManagedClusterClientConfigs());
    }

    @Override
    public Boolean getHubAcceptsClient() {
        return this.hubAcceptsClient;
    }

    @Override
    public A withHubAcceptsClient(Boolean hubAcceptsClient) {
        this.hubAcceptsClient = hubAcceptsClient;
        return (A)this;
    }

    @Override
    public Boolean hasHubAcceptsClient() {
        return this.hubAcceptsClient != null;
    }

    @Override
    public Integer getLeaseDurationSeconds() {
        return this.leaseDurationSeconds;
    }

    @Override
    public A withLeaseDurationSeconds(Integer leaseDurationSeconds) {
        this.leaseDurationSeconds = leaseDurationSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasLeaseDurationSeconds() {
        return this.leaseDurationSeconds != null;
    }

    @Override
    public A addToManagedClusterClientConfigs(Integer index, ClientConfig item) {
        if (this.managedClusterClientConfigs == null) {
            this.managedClusterClientConfigs = new ArrayList<ClientConfigBuilder>();
        }
        ClientConfigBuilder builder = new ClientConfigBuilder(item);
        this._visitables.get((Object)"managedClusterClientConfigs").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"managedClusterClientConfigs").size(), builder);
        this.managedClusterClientConfigs.add(index >= 0 ? index.intValue() : this.managedClusterClientConfigs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToManagedClusterClientConfigs(Integer index, ClientConfig item) {
        if (this.managedClusterClientConfigs == null) {
            this.managedClusterClientConfigs = new ArrayList<ClientConfigBuilder>();
        }
        ClientConfigBuilder builder = new ClientConfigBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"managedClusterClientConfigs").size()) {
            this._visitables.get((Object)"managedClusterClientConfigs").add(builder);
        } else {
            this._visitables.get((Object)"managedClusterClientConfigs").set(index, builder);
        }
        if (index < 0 || index >= this.managedClusterClientConfigs.size()) {
            this.managedClusterClientConfigs.add(builder);
        } else {
            this.managedClusterClientConfigs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToManagedClusterClientConfigs(ClientConfig ... items) {
        if (this.managedClusterClientConfigs == null) {
            this.managedClusterClientConfigs = new ArrayList<ClientConfigBuilder>();
        }
        for (ClientConfig item : items) {
            ClientConfigBuilder builder = new ClientConfigBuilder(item);
            this._visitables.get((Object)"managedClusterClientConfigs").add(builder);
            this.managedClusterClientConfigs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToManagedClusterClientConfigs(Collection<ClientConfig> items) {
        if (this.managedClusterClientConfigs == null) {
            this.managedClusterClientConfigs = new ArrayList<ClientConfigBuilder>();
        }
        for (ClientConfig item : items) {
            ClientConfigBuilder builder = new ClientConfigBuilder(item);
            this._visitables.get((Object)"managedClusterClientConfigs").add(builder);
            this.managedClusterClientConfigs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromManagedClusterClientConfigs(ClientConfig ... items) {
        for (ClientConfig item : items) {
            ClientConfigBuilder builder = new ClientConfigBuilder(item);
            this._visitables.get((Object)"managedClusterClientConfigs").remove(builder);
            if (this.managedClusterClientConfigs == null) continue;
            this.managedClusterClientConfigs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromManagedClusterClientConfigs(Collection<ClientConfig> items) {
        for (ClientConfig item : items) {
            ClientConfigBuilder builder = new ClientConfigBuilder(item);
            this._visitables.get((Object)"managedClusterClientConfigs").remove(builder);
            if (this.managedClusterClientConfigs == null) continue;
            this.managedClusterClientConfigs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromManagedClusterClientConfigs(Predicate<ClientConfigBuilder> predicate) {
        if (this.managedClusterClientConfigs == null) {
            return (A)this;
        }
        Iterator<ClientConfigBuilder> each = this.managedClusterClientConfigs.iterator();
        List visitables = this._visitables.get((Object)"managedClusterClientConfigs");
        while (each.hasNext()) {
            ClientConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClientConfig> getManagedClusterClientConfigs() {
        return ManagedClusterSpecFluentImpl.build(this.managedClusterClientConfigs);
    }

    @Override
    public List<ClientConfig> buildManagedClusterClientConfigs() {
        return ManagedClusterSpecFluentImpl.build(this.managedClusterClientConfigs);
    }

    @Override
    public ClientConfig buildManagedClusterClientConfig(Integer index) {
        return this.managedClusterClientConfigs.get(index).build();
    }

    @Override
    public ClientConfig buildFirstManagedClusterClientConfig() {
        return this.managedClusterClientConfigs.get(0).build();
    }

    @Override
    public ClientConfig buildLastManagedClusterClientConfig() {
        return this.managedClusterClientConfigs.get(this.managedClusterClientConfigs.size() - 1).build();
    }

    @Override
    public ClientConfig buildMatchingManagedClusterClientConfig(Predicate<ClientConfigBuilder> predicate) {
        for (ClientConfigBuilder item : this.managedClusterClientConfigs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingManagedClusterClientConfig(Predicate<ClientConfigBuilder> predicate) {
        for (ClientConfigBuilder item : this.managedClusterClientConfigs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withManagedClusterClientConfigs(List<ClientConfig> managedClusterClientConfigs) {
        if (this.managedClusterClientConfigs != null) {
            this._visitables.get((Object)"managedClusterClientConfigs").removeAll(this.managedClusterClientConfigs);
        }
        if (managedClusterClientConfigs != null) {
            this.managedClusterClientConfigs = new ArrayList<ClientConfigBuilder>();
            for (ClientConfig item : managedClusterClientConfigs) {
                this.addToManagedClusterClientConfigs(item);
            }
        } else {
            this.managedClusterClientConfigs = null;
        }
        return (A)this;
    }

    @Override
    public A withManagedClusterClientConfigs(ClientConfig ... managedClusterClientConfigs) {
        if (this.managedClusterClientConfigs != null) {
            this.managedClusterClientConfigs.clear();
        }
        if (managedClusterClientConfigs != null) {
            for (ClientConfig item : managedClusterClientConfigs) {
                this.addToManagedClusterClientConfigs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasManagedClusterClientConfigs() {
        return this.managedClusterClientConfigs != null && !this.managedClusterClientConfigs.isEmpty();
    }

    @Override
    public A addNewManagedClusterClientConfig(String caBundle, String url) {
        return this.addToManagedClusterClientConfigs(new ClientConfig(caBundle, url));
    }

    @Override
    public ManagedClusterSpecFluent.ManagedClusterClientConfigsNested<A> addNewManagedClusterClientConfig() {
        return new ManagedClusterClientConfigsNestedImpl();
    }

    @Override
    public ManagedClusterSpecFluent.ManagedClusterClientConfigsNested<A> addNewManagedClusterClientConfigLike(ClientConfig item) {
        return new ManagedClusterClientConfigsNestedImpl(-1, item);
    }

    @Override
    public ManagedClusterSpecFluent.ManagedClusterClientConfigsNested<A> setNewManagedClusterClientConfigLike(Integer index, ClientConfig item) {
        return new ManagedClusterClientConfigsNestedImpl(index, item);
    }

    @Override
    public ManagedClusterSpecFluent.ManagedClusterClientConfigsNested<A> editManagedClusterClientConfig(Integer index) {
        if (this.managedClusterClientConfigs.size() <= index) {
            throw new RuntimeException("Can't edit managedClusterClientConfigs. Index exceeds size.");
        }
        return this.setNewManagedClusterClientConfigLike(index, this.buildManagedClusterClientConfig(index));
    }

    @Override
    public ManagedClusterSpecFluent.ManagedClusterClientConfigsNested<A> editFirstManagedClusterClientConfig() {
        if (this.managedClusterClientConfigs.size() == 0) {
            throw new RuntimeException("Can't edit first managedClusterClientConfigs. The list is empty.");
        }
        return this.setNewManagedClusterClientConfigLike(0, this.buildManagedClusterClientConfig(0));
    }

    @Override
    public ManagedClusterSpecFluent.ManagedClusterClientConfigsNested<A> editLastManagedClusterClientConfig() {
        int index = this.managedClusterClientConfigs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last managedClusterClientConfigs. The list is empty.");
        }
        return this.setNewManagedClusterClientConfigLike(index, this.buildManagedClusterClientConfig(index));
    }

    @Override
    public ManagedClusterSpecFluent.ManagedClusterClientConfigsNested<A> editMatchingManagedClusterClientConfig(Predicate<ClientConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.managedClusterClientConfigs.size(); ++i) {
            if (!predicate.test(this.managedClusterClientConfigs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching managedClusterClientConfigs. No match found.");
        }
        return this.setNewManagedClusterClientConfigLike(index, this.buildManagedClusterClientConfig(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedClusterSpecFluentImpl that = (ManagedClusterSpecFluentImpl)o;
        if (this.hubAcceptsClient != null ? !this.hubAcceptsClient.equals(that.hubAcceptsClient) : that.hubAcceptsClient != null) {
            return false;
        }
        if (this.leaseDurationSeconds != null ? !this.leaseDurationSeconds.equals(that.leaseDurationSeconds) : that.leaseDurationSeconds != null) {
            return false;
        }
        return !(this.managedClusterClientConfigs != null ? !this.managedClusterClientConfigs.equals(that.managedClusterClientConfigs) : that.managedClusterClientConfigs != null);
    }

    public int hashCode() {
        return Objects.hash(this.hubAcceptsClient, this.leaseDurationSeconds, this.managedClusterClientConfigs, super.hashCode());
    }

    public class ManagedClusterClientConfigsNestedImpl<N>
    extends ClientConfigFluentImpl<ManagedClusterSpecFluent.ManagedClusterClientConfigsNested<N>>
    implements ManagedClusterSpecFluent.ManagedClusterClientConfigsNested<N>,
    Nested<N> {
        ClientConfigBuilder builder;
        Integer index;

        ManagedClusterClientConfigsNestedImpl(Integer index, ClientConfig item) {
            this.index = index;
            this.builder = new ClientConfigBuilder(this, item);
        }

        ManagedClusterClientConfigsNestedImpl() {
            this.index = -1;
            this.builder = new ClientConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ManagedClusterSpecFluentImpl.this.setToManagedClusterClientConfigs(this.index, this.builder.build());
        }

        @Override
        public N endManagedClusterClientConfig() {
            return this.and();
        }
    }
}

