/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterClaimSelector;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterClaimSelectorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterClaimSelectorFluentImpl<A extends ClusterClaimSelectorFluent<A>>
extends BaseFluent<A>
implements ClusterClaimSelectorFluent<A> {
    private List<LabelSelectorRequirement> matchExpressions = new ArrayList<LabelSelectorRequirement>();

    public ClusterClaimSelectorFluentImpl() {
    }

    public ClusterClaimSelectorFluentImpl(ClusterClaimSelector instance) {
        this.withMatchExpressions(instance.getMatchExpressions());
    }

    @Override
    public A addToMatchExpressions(Integer index, LabelSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirement>();
        }
        this.matchExpressions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMatchExpressions(Integer index, LabelSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirement>();
        }
        this.matchExpressions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMatchExpressions(LabelSelectorRequirement ... items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirement>();
        }
        for (LabelSelectorRequirement item : items) {
            this.matchExpressions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMatchExpressions(Collection<LabelSelectorRequirement> items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirement>();
        }
        for (LabelSelectorRequirement item : items) {
            this.matchExpressions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatchExpressions(LabelSelectorRequirement ... items) {
        for (LabelSelectorRequirement item : items) {
            if (this.matchExpressions == null) continue;
            this.matchExpressions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMatchExpressions(Collection<LabelSelectorRequirement> items) {
        for (LabelSelectorRequirement item : items) {
            if (this.matchExpressions == null) continue;
            this.matchExpressions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<LabelSelectorRequirement> getMatchExpressions() {
        return this.matchExpressions;
    }

    @Override
    public LabelSelectorRequirement getMatchExpression(Integer index) {
        return this.matchExpressions.get(index);
    }

    @Override
    public LabelSelectorRequirement getFirstMatchExpression() {
        return this.matchExpressions.get(0);
    }

    @Override
    public LabelSelectorRequirement getLastMatchExpression() {
        return this.matchExpressions.get(this.matchExpressions.size() - 1);
    }

    @Override
    public LabelSelectorRequirement getMatchingMatchExpression(Predicate<LabelSelectorRequirement> predicate) {
        for (LabelSelectorRequirement item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMatchExpression(Predicate<LabelSelectorRequirement> predicate) {
        for (LabelSelectorRequirement item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMatchExpressions(List<LabelSelectorRequirement> matchExpressions) {
        if (matchExpressions != null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirement>();
            for (LabelSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        } else {
            this.matchExpressions = null;
        }
        return (A)this;
    }

    @Override
    public A withMatchExpressions(LabelSelectorRequirement ... matchExpressions) {
        if (this.matchExpressions != null) {
            this.matchExpressions.clear();
        }
        if (matchExpressions != null) {
            for (LabelSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatchExpressions() {
        return this.matchExpressions != null && !this.matchExpressions.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterClaimSelectorFluentImpl that = (ClusterClaimSelectorFluentImpl)o;
        return !(this.matchExpressions != null ? !this.matchExpressions.equals(that.matchExpressions) : that.matchExpressions != null);
    }

    public int hashCode() {
        return Objects.hash(this.matchExpressions, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.matchExpressions != null && !this.matchExpressions.isEmpty()) {
            sb.append("matchExpressions:");
            sb.append(this.matchExpressions);
        }
        sb.append("}");
        return sb.toString();
    }
}

