/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HiveConfigSpec;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HiveConfigSpecFluent;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HiveConfigSpecFluentImpl;
import java.util.Objects;

public class HiveConfigSpecBuilder
extends HiveConfigSpecFluentImpl<HiveConfigSpecBuilder>
implements VisitableBuilder<HiveConfigSpec, HiveConfigSpecBuilder> {
    HiveConfigSpecFluent<?> fluent;
    Boolean validationEnabled;

    public HiveConfigSpecBuilder() {
        this(false);
    }

    public HiveConfigSpecBuilder(Boolean validationEnabled) {
        this(new HiveConfigSpec(), validationEnabled);
    }

    public HiveConfigSpecBuilder(HiveConfigSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public HiveConfigSpecBuilder(HiveConfigSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HiveConfigSpec(), validationEnabled);
    }

    public HiveConfigSpecBuilder(HiveConfigSpecFluent<?> fluent, HiveConfigSpec instance) {
        this(fluent, instance, false);
    }

    public HiveConfigSpecBuilder(HiveConfigSpecFluent<?> fluent, HiveConfigSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAdditionalCertificateAuthorities(instance.getAdditionalCertificateAuthorities());
        fluent.withBackup(instance.getBackup());
        fluent.withExternalDNS(instance.getExternalDNS());
        fluent.withFailedProvisionConfig(instance.getFailedProvisionConfig());
        fluent.withGlobalPullSecret(instance.getGlobalPullSecret());
        fluent.withMaintenanceMode(instance.getMaintenanceMode());
        this.validationEnabled = validationEnabled;
    }

    public HiveConfigSpecBuilder(HiveConfigSpec instance) {
        this(instance, (Boolean)false);
    }

    public HiveConfigSpecBuilder(HiveConfigSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAdditionalCertificateAuthorities(instance.getAdditionalCertificateAuthorities());
        this.withBackup(instance.getBackup());
        this.withExternalDNS(instance.getExternalDNS());
        this.withFailedProvisionConfig(instance.getFailedProvisionConfig());
        this.withGlobalPullSecret(instance.getGlobalPullSecret());
        this.withMaintenanceMode(instance.getMaintenanceMode());
        this.validationEnabled = validationEnabled;
    }

    public HiveConfigSpec build() {
        HiveConfigSpec buildable = new HiveConfigSpec(this.fluent.getAdditionalCertificateAuthorities(), this.fluent.getBackup(), this.fluent.getExternalDNS(), this.fluent.getFailedProvisionConfig(), this.fluent.getGlobalPullSecret(), this.fluent.getMaintenanceMode());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HiveConfigSpecBuilder that = (HiveConfigSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

