/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HubCondition;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HubConditionBuilder;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HubConditionFluentImpl;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.MultiClusterHubStatus;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.MultiClusterHubStatusFluent;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.StatusCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MultiClusterHubStatusFluentImpl<A extends MultiClusterHubStatusFluent<A>>
extends BaseFluent<A>
implements MultiClusterHubStatusFluent<A> {
    private Map<String, StatusCondition> components;
    private List<HubConditionBuilder> conditions;
    private String currentVersion;
    private String desiredVersion;
    private String phase;

    public MultiClusterHubStatusFluentImpl() {
    }

    public MultiClusterHubStatusFluentImpl(MultiClusterHubStatus instance) {
        this.withComponents(instance.getComponents());
        this.withConditions(instance.getConditions());
        this.withCurrentVersion(instance.getCurrentVersion());
        this.withDesiredVersion(instance.getDesiredVersion());
        this.withPhase(instance.getPhase());
    }

    @Override
    public A addToComponents(String key, StatusCondition value) {
        if (this.components == null && key != null && value != null) {
            this.components = new LinkedHashMap<String, StatusCondition>();
        }
        if (key != null && value != null) {
            this.components.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToComponents(Map<String, StatusCondition> map) {
        if (this.components == null && map != null) {
            this.components = new LinkedHashMap<String, StatusCondition>();
        }
        if (map != null) {
            this.components.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromComponents(String key) {
        if (this.components == null) {
            return (A)this;
        }
        if (key != null && this.components != null) {
            this.components.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromComponents(Map<String, StatusCondition> map) {
        if (this.components == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.components == null) continue;
                this.components.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, StatusCondition> getComponents() {
        return this.components;
    }

    @Override
    public <K, V> A withComponents(Map<String, StatusCondition> components) {
        this.components = components == null ? null : new LinkedHashMap<String, StatusCondition>(components);
        return (A)this;
    }

    @Override
    public Boolean hasComponents() {
        return this.components != null;
    }

    @Override
    public A addToConditions(Integer index, HubCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<HubConditionBuilder>();
        }
        HubConditionBuilder builder = new HubConditionBuilder(item);
        this._visitables.get((Object)"conditions").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, HubCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<HubConditionBuilder>();
        }
        HubConditionBuilder builder = new HubConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"conditions").size()) {
            this._visitables.get((Object)"conditions").add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(HubCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<HubConditionBuilder>();
        }
        for (HubCondition item : items) {
            HubConditionBuilder builder = new HubConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<HubCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<HubConditionBuilder>();
        }
        for (HubCondition item : items) {
            HubConditionBuilder builder = new HubConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(HubCondition ... items) {
        for (HubCondition item : items) {
            HubConditionBuilder builder = new HubConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<HubCondition> items) {
        for (HubCondition item : items) {
            HubConditionBuilder builder = new HubConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<HubConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<HubConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            HubConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HubCondition> getConditions() {
        return MultiClusterHubStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<HubCondition> buildConditions() {
        return MultiClusterHubStatusFluentImpl.build(this.conditions);
    }

    @Override
    public HubCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public HubCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public HubCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public HubCondition buildMatchingCondition(Predicate<HubConditionBuilder> predicate) {
        for (HubConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<HubConditionBuilder> predicate) {
        for (HubConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<HubCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<HubConditionBuilder>();
            for (HubCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(HubCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (HubCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public MultiClusterHubStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public MultiClusterHubStatusFluent.ConditionsNested<A> addNewConditionLike(HubCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public MultiClusterHubStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, HubCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public MultiClusterHubStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public MultiClusterHubStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public MultiClusterHubStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public MultiClusterHubStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<HubConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public String getCurrentVersion() {
        return this.currentVersion;
    }

    @Override
    public A withCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentVersion() {
        return this.currentVersion != null;
    }

    @Override
    @Deprecated
    public A withNewCurrentVersion(String arg0) {
        return this.withCurrentVersion(new String(arg0));
    }

    @Override
    public String getDesiredVersion() {
        return this.desiredVersion;
    }

    @Override
    public A withDesiredVersion(String desiredVersion) {
        this.desiredVersion = desiredVersion;
        return (A)this;
    }

    @Override
    public Boolean hasDesiredVersion() {
        return this.desiredVersion != null;
    }

    @Override
    @Deprecated
    public A withNewDesiredVersion(String arg0) {
        return this.withDesiredVersion(new String(arg0));
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public Boolean hasPhase() {
        return this.phase != null;
    }

    @Override
    @Deprecated
    public A withNewPhase(String arg0) {
        return this.withPhase(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiClusterHubStatusFluentImpl that = (MultiClusterHubStatusFluentImpl)o;
        if (this.components != null ? !this.components.equals(that.components) : that.components != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.currentVersion != null ? !this.currentVersion.equals(that.currentVersion) : that.currentVersion != null) {
            return false;
        }
        if (this.desiredVersion != null ? !this.desiredVersion.equals(that.desiredVersion) : that.desiredVersion != null) {
            return false;
        }
        return !(this.phase != null ? !this.phase.equals(that.phase) : that.phase != null);
    }

    public int hashCode() {
        return Objects.hash(this.components, this.conditions, this.currentVersion, this.desiredVersion, this.phase, super.hashCode());
    }

    public class ConditionsNestedImpl<N>
    extends HubConditionFluentImpl<MultiClusterHubStatusFluent.ConditionsNested<N>>
    implements MultiClusterHubStatusFluent.ConditionsNested<N>,
    Nested<N> {
        HubConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, HubCondition item) {
            this.index = index;
            this.builder = new HubConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new HubConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)MultiClusterHubStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

