/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatus;
import io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus;
import io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta;
import io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterManagerStatusFluent<A extends ClusterManagerStatusFluent<A>>
extends BaseFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private ArrayList<GenerationStatusBuilder> generations = new ArrayList();
    private Long observedGeneration;
    private ArrayList<RelatedResourceMetaBuilder> relatedResources = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ClusterManagerStatusFluent() {
    }

    public ClusterManagerStatusFluent(ClusterManagerStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterManagerStatus instance) {
        ClusterManagerStatus clusterManagerStatus = instance = instance != null ? instance : new ClusterManagerStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withGenerations(instance.getGenerations());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withRelatedResources(instance.getRelatedResources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addToGenerations(int index, GenerationStatus item) {
        if (this.generations == null) {
            this.generations = new ArrayList();
        }
        GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
        if (index < 0 || index >= this.generations.size()) {
            this._visitables.get((Object)"generations").add(builder);
            this.generations.add(builder);
        } else {
            this._visitables.get((Object)"generations").add(index, builder);
            this.generations.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToGenerations(int index, GenerationStatus item) {
        if (this.generations == null) {
            this.generations = new ArrayList();
        }
        GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
        if (index < 0 || index >= this.generations.size()) {
            this._visitables.get((Object)"generations").add(builder);
            this.generations.add(builder);
        } else {
            this._visitables.get((Object)"generations").set(index, builder);
            this.generations.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToGenerations(GenerationStatus ... items) {
        if (this.generations == null) {
            this.generations = new ArrayList();
        }
        for (GenerationStatus item : items) {
            GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
            this._visitables.get((Object)"generations").add(builder);
            this.generations.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToGenerations(Collection<GenerationStatus> items) {
        if (this.generations == null) {
            this.generations = new ArrayList();
        }
        for (GenerationStatus item : items) {
            GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
            this._visitables.get((Object)"generations").add(builder);
            this.generations.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromGenerations(GenerationStatus ... items) {
        if (this.generations == null) {
            return (A)((Object)this);
        }
        for (GenerationStatus item : items) {
            GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
            this._visitables.get((Object)"generations").remove((Object)builder);
            this.generations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromGenerations(Collection<GenerationStatus> items) {
        if (this.generations == null) {
            return (A)((Object)this);
        }
        for (GenerationStatus item : items) {
            GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
            this._visitables.get((Object)"generations").remove((Object)builder);
            this.generations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromGenerations(Predicate<GenerationStatusBuilder> predicate) {
        if (this.generations == null) {
            return (A)((Object)this);
        }
        Iterator<GenerationStatusBuilder> each = this.generations.iterator();
        List visitables = this._visitables.get((Object)"generations");
        while (each.hasNext()) {
            GenerationStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GenerationStatus> buildGenerations() {
        return this.generations != null ? ClusterManagerStatusFluent.build(this.generations) : null;
    }

    public GenerationStatus buildGeneration(int index) {
        return this.generations.get(index).build();
    }

    public GenerationStatus buildFirstGeneration() {
        return this.generations.get(0).build();
    }

    public GenerationStatus buildLastGeneration() {
        return this.generations.get(this.generations.size() - 1).build();
    }

    public GenerationStatus buildMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
        for (GenerationStatusBuilder item : this.generations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
        for (GenerationStatusBuilder item : this.generations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGenerations(List<GenerationStatus> generations) {
        if (this.generations != null) {
            this._visitables.get((Object)"generations").clear();
        }
        if (generations != null) {
            this.generations = new ArrayList();
            for (GenerationStatus item : generations) {
                this.addToGenerations(item);
            }
        } else {
            this.generations = null;
        }
        return (A)((Object)this);
    }

    public A withGenerations(GenerationStatus ... generations) {
        if (this.generations != null) {
            this.generations.clear();
            this._visitables.remove((Object)"generations");
        }
        if (generations != null) {
            for (GenerationStatus item : generations) {
                this.addToGenerations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasGenerations() {
        return this.generations != null && !this.generations.isEmpty();
    }

    public GenerationsNested<A> addNewGeneration() {
        return new GenerationsNested(-1, null);
    }

    public GenerationsNested<A> addNewGenerationLike(GenerationStatus item) {
        return new GenerationsNested(-1, item);
    }

    public GenerationsNested<A> setNewGenerationLike(int index, GenerationStatus item) {
        return new GenerationsNested(index, item);
    }

    public GenerationsNested<A> editGeneration(int index) {
        if (this.generations.size() <= index) {
            throw new RuntimeException("Can't edit generations. Index exceeds size.");
        }
        return this.setNewGenerationLike(index, this.buildGeneration(index));
    }

    public GenerationsNested<A> editFirstGeneration() {
        if (this.generations.size() == 0) {
            throw new RuntimeException("Can't edit first generations. The list is empty.");
        }
        return this.setNewGenerationLike(0, this.buildGeneration(0));
    }

    public GenerationsNested<A> editLastGeneration() {
        int index = this.generations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last generations. The list is empty.");
        }
        return this.setNewGenerationLike(index, this.buildGeneration(index));
    }

    public GenerationsNested<A> editMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.generations.size(); ++i) {
            if (!predicate.test(this.generations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching generations. No match found.");
        }
        return this.setNewGenerationLike(index, this.buildGeneration(index));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A addToRelatedResources(int index, RelatedResourceMeta item) {
        if (this.relatedResources == null) {
            this.relatedResources = new ArrayList();
        }
        RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);
        if (index < 0 || index >= this.relatedResources.size()) {
            this._visitables.get((Object)"relatedResources").add(builder);
            this.relatedResources.add(builder);
        } else {
            this._visitables.get((Object)"relatedResources").add(index, builder);
            this.relatedResources.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRelatedResources(int index, RelatedResourceMeta item) {
        if (this.relatedResources == null) {
            this.relatedResources = new ArrayList();
        }
        RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);
        if (index < 0 || index >= this.relatedResources.size()) {
            this._visitables.get((Object)"relatedResources").add(builder);
            this.relatedResources.add(builder);
        } else {
            this._visitables.get((Object)"relatedResources").set(index, builder);
            this.relatedResources.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRelatedResources(RelatedResourceMeta ... items) {
        if (this.relatedResources == null) {
            this.relatedResources = new ArrayList();
        }
        for (RelatedResourceMeta item : items) {
            RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);
            this._visitables.get((Object)"relatedResources").add(builder);
            this.relatedResources.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRelatedResources(Collection<RelatedResourceMeta> items) {
        if (this.relatedResources == null) {
            this.relatedResources = new ArrayList();
        }
        for (RelatedResourceMeta item : items) {
            RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);
            this._visitables.get((Object)"relatedResources").add(builder);
            this.relatedResources.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRelatedResources(RelatedResourceMeta ... items) {
        if (this.relatedResources == null) {
            return (A)((Object)this);
        }
        for (RelatedResourceMeta item : items) {
            RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);
            this._visitables.get((Object)"relatedResources").remove((Object)builder);
            this.relatedResources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRelatedResources(Collection<RelatedResourceMeta> items) {
        if (this.relatedResources == null) {
            return (A)((Object)this);
        }
        for (RelatedResourceMeta item : items) {
            RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);
            this._visitables.get((Object)"relatedResources").remove((Object)builder);
            this.relatedResources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRelatedResources(Predicate<RelatedResourceMetaBuilder> predicate) {
        if (this.relatedResources == null) {
            return (A)((Object)this);
        }
        Iterator<RelatedResourceMetaBuilder> each = this.relatedResources.iterator();
        List visitables = this._visitables.get((Object)"relatedResources");
        while (each.hasNext()) {
            RelatedResourceMetaBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<RelatedResourceMeta> buildRelatedResources() {
        return this.relatedResources != null ? ClusterManagerStatusFluent.build(this.relatedResources) : null;
    }

    public RelatedResourceMeta buildRelatedResource(int index) {
        return this.relatedResources.get(index).build();
    }

    public RelatedResourceMeta buildFirstRelatedResource() {
        return this.relatedResources.get(0).build();
    }

    public RelatedResourceMeta buildLastRelatedResource() {
        return this.relatedResources.get(this.relatedResources.size() - 1).build();
    }

    public RelatedResourceMeta buildMatchingRelatedResource(Predicate<RelatedResourceMetaBuilder> predicate) {
        for (RelatedResourceMetaBuilder item : this.relatedResources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRelatedResource(Predicate<RelatedResourceMetaBuilder> predicate) {
        for (RelatedResourceMetaBuilder item : this.relatedResources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRelatedResources(List<RelatedResourceMeta> relatedResources) {
        if (this.relatedResources != null) {
            this._visitables.get((Object)"relatedResources").clear();
        }
        if (relatedResources != null) {
            this.relatedResources = new ArrayList();
            for (RelatedResourceMeta item : relatedResources) {
                this.addToRelatedResources(item);
            }
        } else {
            this.relatedResources = null;
        }
        return (A)((Object)this);
    }

    public A withRelatedResources(RelatedResourceMeta ... relatedResources) {
        if (this.relatedResources != null) {
            this.relatedResources.clear();
            this._visitables.remove((Object)"relatedResources");
        }
        if (relatedResources != null) {
            for (RelatedResourceMeta item : relatedResources) {
                this.addToRelatedResources(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRelatedResources() {
        return this.relatedResources != null && !this.relatedResources.isEmpty();
    }

    public A addNewRelatedResource(String group, String name, String namespace, String resource, String version) {
        return this.addToRelatedResources(new RelatedResourceMeta(group, name, namespace, resource, version));
    }

    public RelatedResourcesNested<A> addNewRelatedResource() {
        return new RelatedResourcesNested(-1, null);
    }

    public RelatedResourcesNested<A> addNewRelatedResourceLike(RelatedResourceMeta item) {
        return new RelatedResourcesNested(-1, item);
    }

    public RelatedResourcesNested<A> setNewRelatedResourceLike(int index, RelatedResourceMeta item) {
        return new RelatedResourcesNested(index, item);
    }

    public RelatedResourcesNested<A> editRelatedResource(int index) {
        if (this.relatedResources.size() <= index) {
            throw new RuntimeException("Can't edit relatedResources. Index exceeds size.");
        }
        return this.setNewRelatedResourceLike(index, this.buildRelatedResource(index));
    }

    public RelatedResourcesNested<A> editFirstRelatedResource() {
        if (this.relatedResources.size() == 0) {
            throw new RuntimeException("Can't edit first relatedResources. The list is empty.");
        }
        return this.setNewRelatedResourceLike(0, this.buildRelatedResource(0));
    }

    public RelatedResourcesNested<A> editLastRelatedResource() {
        int index = this.relatedResources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last relatedResources. The list is empty.");
        }
        return this.setNewRelatedResourceLike(index, this.buildRelatedResource(index));
    }

    public RelatedResourcesNested<A> editMatchingRelatedResource(Predicate<RelatedResourceMetaBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.relatedResources.size(); ++i) {
            if (!predicate.test(this.relatedResources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching relatedResources. No match found.");
        }
        return this.setNewRelatedResourceLike(index, this.buildRelatedResource(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterManagerStatusFluent that = (ClusterManagerStatusFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.generations, that.generations)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.relatedResources, that.relatedResources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.generations, this.observedGeneration, this.relatedResources, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.generations != null && !this.generations.isEmpty()) {
            sb.append("generations:");
            sb.append(this.generations + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.relatedResources != null && !this.relatedResources.isEmpty()) {
            sb.append("relatedResources:");
            sb.append(this.relatedResources + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RelatedResourcesNested<N>
    extends RelatedResourceMetaFluent<RelatedResourcesNested<N>>
    implements Nested<N> {
        RelatedResourceMetaBuilder builder;
        int index;

        RelatedResourcesNested(int index, RelatedResourceMeta item) {
            this.index = index;
            this.builder = new RelatedResourceMetaBuilder(this, item);
        }

        public N and() {
            return (N)ClusterManagerStatusFluent.this.setToRelatedResources(this.index, this.builder.build());
        }

        public N endRelatedResource() {
            return this.and();
        }
    }

    public class GenerationsNested<N>
    extends GenerationStatusFluent<GenerationsNested<N>>
    implements Nested<N> {
        GenerationStatusBuilder builder;
        int index;

        GenerationsNested(int index, GenerationStatus item) {
            this.index = index;
            this.builder = new GenerationStatusBuilder(this, item);
        }

        public N and() {
            return (N)ClusterManagerStatusFluent.this.setToGenerations(this.index, this.builder.build());
        }

        public N endGeneration() {
            return this.and();
        }
    }
}

