/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import com.squareup.okhttp.OkHttpClient;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.EditReplaceDeletable;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.openshift.client.OpenShiftConfig;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class OpenShiftOperation<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends ClientResource<T, D>>
extends HasMetadataOperation<T, L, D, R> {
    protected OpenShiftOperation(OkHttpClient client, OpenShiftConfig config, String apiGroup, String apiVersion, String resourceT, String namespace, String name, Boolean cascading, T item, String resourceVersion) {
        super(client, (Config)config, apiGroup, apiVersion, resourceT, namespace, name, cascading, item, resourceVersion);
    }

    public URL getRootUrl() {
        try {
            return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public R withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        try {
            return (R)((ClientResource)((Object)((Object)this)).getClass().getConstructor(OkHttpClient.class, OpenShiftConfig.class, String.class, String.class, String.class, Boolean.class, this.getType(), String.class).newInstance(new Object[]{this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), name, this.isCascading(), this.getItem(), this.getResourceVersion()}));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    public OpenShiftOperation<T, L, D, R> inNamespace(String namespace) {
        try {
            return (OpenShiftOperation)((Object)((Object)((Object)this)).getClass().getConstructor(OkHttpClient.class, OpenShiftConfig.class, String.class, String.class, String.class, Boolean.class, this.getType(), String.class).newInstance(new Object[]{this.client, this.getConfig(), this.getAPIVersion(), namespace, this.getName(), this.isCascading(), this.getItem(), this.getResourceVersion()}));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    public EditReplaceDeletable<T, T, D, Boolean> cascading(boolean enabled) {
        try {
            return (ClientResource)((Object)((Object)this)).getClass().getConstructor(OkHttpClient.class, OpenShiftConfig.class, String.class, String.class, String.class, Boolean.class, this.getType(), String.class).newInstance(new Object[]{this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), enabled, this.getItem(), this.getResourceVersion()});
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    public R load(InputStream is) {
        try {
            return (R)((ClientResource)((Object)((Object)this)).getClass().getConstructor(OkHttpClient.class, OpenShiftConfig.class, String.class, String.class, String.class, Boolean.class, this.getType(), String.class).newInstance(new Object[]{this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), this.unmarshal(is, this.getType()), this.getResourceVersion()}));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    public OpenShiftConfig getConfig() {
        return OpenShiftConfig.wrap(super.getConfig());
    }
}

