package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ResourceRangeBuilder extends ResourceRangeFluent<ResourceRangeBuilder> implements VisitableBuilder<ResourceRange,ResourceRangeBuilder>{
  public ResourceRangeBuilder() {
    this(new ResourceRange());
  }
  
  public ResourceRangeBuilder(ResourceRangeFluent<?> fluent) {
    this(fluent, new ResourceRange());
  }
  
  public ResourceRangeBuilder(ResourceRangeFluent<?> fluent,ResourceRange instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ResourceRangeBuilder(ResourceRange instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ResourceRangeFluent<?> fluent;
  
  public ResourceRange build() {
    ResourceRange buildable = new ResourceRange(fluent.getMax(),fluent.getMin());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}