package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class HubSourceStatusBuilder extends HubSourceStatusFluent<HubSourceStatusBuilder> implements VisitableBuilder<HubSourceStatus,HubSourceStatusBuilder>{
  public HubSourceStatusBuilder() {
    this(new HubSourceStatus());
  }
  
  public HubSourceStatusBuilder(HubSourceStatusFluent<?> fluent) {
    this(fluent, new HubSourceStatus());
  }
  
  public HubSourceStatusBuilder(HubSourceStatusFluent<?> fluent,HubSourceStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public HubSourceStatusBuilder(HubSourceStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  HubSourceStatusFluent<?> fluent;
  
  public HubSourceStatus build() {
    HubSourceStatus buildable = new HubSourceStatus(fluent.getDisabled(),fluent.getMessage(),fluent.getName(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}