package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ProjectSpecBuilder extends ProjectSpecFluent<ProjectSpecBuilder> implements VisitableBuilder<ProjectSpec,ProjectSpecBuilder>{
  public ProjectSpecBuilder() {
    this(new ProjectSpec());
  }
  
  public ProjectSpecBuilder(ProjectSpecFluent<?> fluent) {
    this(fluent, new ProjectSpec());
  }
  
  public ProjectSpecBuilder(ProjectSpecFluent<?> fluent,ProjectSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ProjectSpecBuilder(ProjectSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ProjectSpecFluent<?> fluent;
  
  public ProjectSpec build() {
    ProjectSpec buildable = new ProjectSpec(fluent.getProjectRequestMessage(),fluent.buildProjectRequestTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}