/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.NutanixPlatformLoadBalancer;
import io.fabric8.openshift.api.model.config.v1.NutanixPlatformLoadBalancerBuilder;
import io.fabric8.openshift.api.model.config.v1.NutanixPlatformLoadBalancerFluent;
import io.fabric8.openshift.api.model.config.v1.NutanixPlatformStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NutanixPlatformStatusFluent<A extends NutanixPlatformStatusFluent<A>>
extends BaseFluent<A> {
    private String apiServerInternalIP;
    private List<String> apiServerInternalIPs = new ArrayList<String>();
    private String ingressIP;
    private List<String> ingressIPs = new ArrayList<String>();
    private NutanixPlatformLoadBalancerBuilder loadBalancer;
    private Map<String, Object> additionalProperties;

    public NutanixPlatformStatusFluent() {
    }

    public NutanixPlatformStatusFluent(NutanixPlatformStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NutanixPlatformStatus instance) {
        NutanixPlatformStatus nutanixPlatformStatus = instance = instance != null ? instance : new NutanixPlatformStatus();
        if (instance != null) {
            this.withApiServerInternalIP(instance.getApiServerInternalIP());
            this.withApiServerInternalIPs(instance.getApiServerInternalIPs());
            this.withIngressIP(instance.getIngressIP());
            this.withIngressIPs(instance.getIngressIPs());
            this.withLoadBalancer(instance.getLoadBalancer());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiServerInternalIP() {
        return this.apiServerInternalIP;
    }

    public A withApiServerInternalIP(String apiServerInternalIP) {
        this.apiServerInternalIP = apiServerInternalIP;
        return (A)((Object)this);
    }

    public boolean hasApiServerInternalIP() {
        return this.apiServerInternalIP != null;
    }

    public A addToApiServerInternalIPs(int index, String item) {
        if (this.apiServerInternalIPs == null) {
            this.apiServerInternalIPs = new ArrayList<String>();
        }
        this.apiServerInternalIPs.add(index, item);
        return (A)((Object)this);
    }

    public A setToApiServerInternalIPs(int index, String item) {
        if (this.apiServerInternalIPs == null) {
            this.apiServerInternalIPs = new ArrayList<String>();
        }
        this.apiServerInternalIPs.set(index, item);
        return (A)((Object)this);
    }

    public A addToApiServerInternalIPs(String ... items) {
        if (this.apiServerInternalIPs == null) {
            this.apiServerInternalIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiServerInternalIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToApiServerInternalIPs(Collection<String> items) {
        if (this.apiServerInternalIPs == null) {
            this.apiServerInternalIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiServerInternalIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromApiServerInternalIPs(String ... items) {
        if (this.apiServerInternalIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.apiServerInternalIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromApiServerInternalIPs(Collection<String> items) {
        if (this.apiServerInternalIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.apiServerInternalIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getApiServerInternalIPs() {
        return this.apiServerInternalIPs;
    }

    public String getApiServerInternalIP(int index) {
        return this.apiServerInternalIPs.get(index);
    }

    public String getFirstApiServerInternalIP() {
        return this.apiServerInternalIPs.get(0);
    }

    public String getLastApiServerInternalIP() {
        return this.apiServerInternalIPs.get(this.apiServerInternalIPs.size() - 1);
    }

    public String getMatchingApiServerInternalIP(Predicate<String> predicate) {
        for (String item : this.apiServerInternalIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingApiServerInternalIP(Predicate<String> predicate) {
        for (String item : this.apiServerInternalIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withApiServerInternalIPs(List<String> apiServerInternalIPs) {
        if (apiServerInternalIPs != null) {
            this.apiServerInternalIPs = new ArrayList<String>();
            for (String item : apiServerInternalIPs) {
                this.addToApiServerInternalIPs(item);
            }
        } else {
            this.apiServerInternalIPs = null;
        }
        return (A)((Object)this);
    }

    public A withApiServerInternalIPs(String ... apiServerInternalIPs) {
        if (this.apiServerInternalIPs != null) {
            this.apiServerInternalIPs.clear();
            this._visitables.remove((Object)"apiServerInternalIPs");
        }
        if (apiServerInternalIPs != null) {
            for (String item : apiServerInternalIPs) {
                this.addToApiServerInternalIPs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasApiServerInternalIPs() {
        return this.apiServerInternalIPs != null && !this.apiServerInternalIPs.isEmpty();
    }

    public String getIngressIP() {
        return this.ingressIP;
    }

    public A withIngressIP(String ingressIP) {
        this.ingressIP = ingressIP;
        return (A)((Object)this);
    }

    public boolean hasIngressIP() {
        return this.ingressIP != null;
    }

    public A addToIngressIPs(int index, String item) {
        if (this.ingressIPs == null) {
            this.ingressIPs = new ArrayList<String>();
        }
        this.ingressIPs.add(index, item);
        return (A)((Object)this);
    }

    public A setToIngressIPs(int index, String item) {
        if (this.ingressIPs == null) {
            this.ingressIPs = new ArrayList<String>();
        }
        this.ingressIPs.set(index, item);
        return (A)((Object)this);
    }

    public A addToIngressIPs(String ... items) {
        if (this.ingressIPs == null) {
            this.ingressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.ingressIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToIngressIPs(Collection<String> items) {
        if (this.ingressIPs == null) {
            this.ingressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.ingressIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromIngressIPs(String ... items) {
        if (this.ingressIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ingressIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIngressIPs(Collection<String> items) {
        if (this.ingressIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ingressIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getIngressIPs() {
        return this.ingressIPs;
    }

    public String getIngressIP(int index) {
        return this.ingressIPs.get(index);
    }

    public String getFirstIngressIP() {
        return this.ingressIPs.get(0);
    }

    public String getLastIngressIP() {
        return this.ingressIPs.get(this.ingressIPs.size() - 1);
    }

    public String getMatchingIngressIP(Predicate<String> predicate) {
        for (String item : this.ingressIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIngressIP(Predicate<String> predicate) {
        for (String item : this.ingressIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIngressIPs(List<String> ingressIPs) {
        if (ingressIPs != null) {
            this.ingressIPs = new ArrayList<String>();
            for (String item : ingressIPs) {
                this.addToIngressIPs(item);
            }
        } else {
            this.ingressIPs = null;
        }
        return (A)((Object)this);
    }

    public A withIngressIPs(String ... ingressIPs) {
        if (this.ingressIPs != null) {
            this.ingressIPs.clear();
            this._visitables.remove((Object)"ingressIPs");
        }
        if (ingressIPs != null) {
            for (String item : ingressIPs) {
                this.addToIngressIPs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIngressIPs() {
        return this.ingressIPs != null && !this.ingressIPs.isEmpty();
    }

    public NutanixPlatformLoadBalancer buildLoadBalancer() {
        return this.loadBalancer != null ? this.loadBalancer.build() : null;
    }

    public A withLoadBalancer(NutanixPlatformLoadBalancer loadBalancer) {
        this._visitables.remove((Object)"loadBalancer");
        if (loadBalancer != null) {
            this.loadBalancer = new NutanixPlatformLoadBalancerBuilder(loadBalancer);
            this._visitables.get((Object)"loadBalancer").add(this.loadBalancer);
        } else {
            this.loadBalancer = null;
            this._visitables.get((Object)"loadBalancer").remove((Object)this.loadBalancer);
        }
        return (A)((Object)this);
    }

    public boolean hasLoadBalancer() {
        return this.loadBalancer != null;
    }

    public A withNewLoadBalancer(String type) {
        return this.withLoadBalancer(new NutanixPlatformLoadBalancer(type));
    }

    public LoadBalancerNested<A> withNewLoadBalancer() {
        return new LoadBalancerNested(null);
    }

    public LoadBalancerNested<A> withNewLoadBalancerLike(NutanixPlatformLoadBalancer item) {
        return new LoadBalancerNested(item);
    }

    public LoadBalancerNested<A> editLoadBalancer() {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(null));
    }

    public LoadBalancerNested<A> editOrNewLoadBalancer() {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(new NutanixPlatformLoadBalancerBuilder().build()));
    }

    public LoadBalancerNested<A> editOrNewLoadBalancerLike(NutanixPlatformLoadBalancer item) {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NutanixPlatformStatusFluent that = (NutanixPlatformStatusFluent)((Object)o);
        if (!Objects.equals(this.apiServerInternalIP, that.apiServerInternalIP)) {
            return false;
        }
        if (!Objects.equals(this.apiServerInternalIPs, that.apiServerInternalIPs)) {
            return false;
        }
        if (!Objects.equals(this.ingressIP, that.ingressIP)) {
            return false;
        }
        if (!Objects.equals(this.ingressIPs, that.ingressIPs)) {
            return false;
        }
        if (!Objects.equals((Object)this.loadBalancer, (Object)that.loadBalancer)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiServerInternalIP, this.apiServerInternalIPs, this.ingressIP, this.ingressIPs, this.loadBalancer, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiServerInternalIP != null) {
            sb.append("apiServerInternalIP:");
            sb.append(this.apiServerInternalIP + ",");
        }
        if (this.apiServerInternalIPs != null && !this.apiServerInternalIPs.isEmpty()) {
            sb.append("apiServerInternalIPs:");
            sb.append(this.apiServerInternalIPs + ",");
        }
        if (this.ingressIP != null) {
            sb.append("ingressIP:");
            sb.append(this.ingressIP + ",");
        }
        if (this.ingressIPs != null && !this.ingressIPs.isEmpty()) {
            sb.append("ingressIPs:");
            sb.append(this.ingressIPs + ",");
        }
        if (this.loadBalancer != null) {
            sb.append("loadBalancer:");
            sb.append((Object)((Object)this.loadBalancer) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LoadBalancerNested<N>
    extends NutanixPlatformLoadBalancerFluent<LoadBalancerNested<N>>
    implements Nested<N> {
        NutanixPlatformLoadBalancerBuilder builder;

        LoadBalancerNested(NutanixPlatformLoadBalancer item) {
            this.builder = new NutanixPlatformLoadBalancerBuilder(this, item);
        }

        public N and() {
            return (N)NutanixPlatformStatusFluent.this.withLoadBalancer(this.builder.build());
        }

        public N endLoadBalancer() {
            return this.and();
        }
    }
}

