/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.NutanixPlatformSpec;
import io.fabric8.openshift.api.model.config.v1.NutanixPrismElementEndpoint;
import io.fabric8.openshift.api.model.config.v1.NutanixPrismElementEndpointBuilder;
import io.fabric8.openshift.api.model.config.v1.NutanixPrismElementEndpointFluent;
import io.fabric8.openshift.api.model.config.v1.NutanixPrismEndpoint;
import io.fabric8.openshift.api.model.config.v1.NutanixPrismEndpointBuilder;
import io.fabric8.openshift.api.model.config.v1.NutanixPrismEndpointFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NutanixPlatformSpecFluent<A extends NutanixPlatformSpecFluent<A>>
extends BaseFluent<A> {
    private NutanixPrismEndpointBuilder prismCentral;
    private ArrayList<NutanixPrismElementEndpointBuilder> prismElements = new ArrayList();
    private Map<String, Object> additionalProperties;

    public NutanixPlatformSpecFluent() {
    }

    public NutanixPlatformSpecFluent(NutanixPlatformSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NutanixPlatformSpec instance) {
        NutanixPlatformSpec nutanixPlatformSpec = instance = instance != null ? instance : new NutanixPlatformSpec();
        if (instance != null) {
            this.withPrismCentral(instance.getPrismCentral());
            this.withPrismElements(instance.getPrismElements());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public NutanixPrismEndpoint buildPrismCentral() {
        return this.prismCentral != null ? this.prismCentral.build() : null;
    }

    public A withPrismCentral(NutanixPrismEndpoint prismCentral) {
        this._visitables.remove((Object)"prismCentral");
        if (prismCentral != null) {
            this.prismCentral = new NutanixPrismEndpointBuilder(prismCentral);
            this._visitables.get((Object)"prismCentral").add(this.prismCentral);
        } else {
            this.prismCentral = null;
            this._visitables.get((Object)"prismCentral").remove((Object)this.prismCentral);
        }
        return (A)((Object)this);
    }

    public boolean hasPrismCentral() {
        return this.prismCentral != null;
    }

    public A withNewPrismCentral(String address, Integer port) {
        return this.withPrismCentral(new NutanixPrismEndpoint(address, port));
    }

    public PrismCentralNested<A> withNewPrismCentral() {
        return new PrismCentralNested(null);
    }

    public PrismCentralNested<A> withNewPrismCentralLike(NutanixPrismEndpoint item) {
        return new PrismCentralNested(item);
    }

    public PrismCentralNested<A> editPrismCentral() {
        return this.withNewPrismCentralLike(Optional.ofNullable(this.buildPrismCentral()).orElse(null));
    }

    public PrismCentralNested<A> editOrNewPrismCentral() {
        return this.withNewPrismCentralLike(Optional.ofNullable(this.buildPrismCentral()).orElse(new NutanixPrismEndpointBuilder().build()));
    }

    public PrismCentralNested<A> editOrNewPrismCentralLike(NutanixPrismEndpoint item) {
        return this.withNewPrismCentralLike(Optional.ofNullable(this.buildPrismCentral()).orElse(item));
    }

    public A addToPrismElements(int index, NutanixPrismElementEndpoint item) {
        if (this.prismElements == null) {
            this.prismElements = new ArrayList();
        }
        NutanixPrismElementEndpointBuilder builder = new NutanixPrismElementEndpointBuilder(item);
        if (index < 0 || index >= this.prismElements.size()) {
            this._visitables.get((Object)"prismElements").add(builder);
            this.prismElements.add(builder);
        } else {
            this._visitables.get((Object)"prismElements").add(index, builder);
            this.prismElements.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPrismElements(int index, NutanixPrismElementEndpoint item) {
        if (this.prismElements == null) {
            this.prismElements = new ArrayList();
        }
        NutanixPrismElementEndpointBuilder builder = new NutanixPrismElementEndpointBuilder(item);
        if (index < 0 || index >= this.prismElements.size()) {
            this._visitables.get((Object)"prismElements").add(builder);
            this.prismElements.add(builder);
        } else {
            this._visitables.get((Object)"prismElements").set(index, builder);
            this.prismElements.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPrismElements(NutanixPrismElementEndpoint ... items) {
        if (this.prismElements == null) {
            this.prismElements = new ArrayList();
        }
        for (NutanixPrismElementEndpoint item : items) {
            NutanixPrismElementEndpointBuilder builder = new NutanixPrismElementEndpointBuilder(item);
            this._visitables.get((Object)"prismElements").add(builder);
            this.prismElements.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPrismElements(Collection<NutanixPrismElementEndpoint> items) {
        if (this.prismElements == null) {
            this.prismElements = new ArrayList();
        }
        for (NutanixPrismElementEndpoint item : items) {
            NutanixPrismElementEndpointBuilder builder = new NutanixPrismElementEndpointBuilder(item);
            this._visitables.get((Object)"prismElements").add(builder);
            this.prismElements.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPrismElements(NutanixPrismElementEndpoint ... items) {
        if (this.prismElements == null) {
            return (A)((Object)this);
        }
        for (NutanixPrismElementEndpoint item : items) {
            NutanixPrismElementEndpointBuilder builder = new NutanixPrismElementEndpointBuilder(item);
            this._visitables.get((Object)"prismElements").remove((Object)builder);
            this.prismElements.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPrismElements(Collection<NutanixPrismElementEndpoint> items) {
        if (this.prismElements == null) {
            return (A)((Object)this);
        }
        for (NutanixPrismElementEndpoint item : items) {
            NutanixPrismElementEndpointBuilder builder = new NutanixPrismElementEndpointBuilder(item);
            this._visitables.get((Object)"prismElements").remove((Object)builder);
            this.prismElements.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPrismElements(Predicate<NutanixPrismElementEndpointBuilder> predicate) {
        if (this.prismElements == null) {
            return (A)((Object)this);
        }
        Iterator<NutanixPrismElementEndpointBuilder> each = this.prismElements.iterator();
        List visitables = this._visitables.get((Object)"prismElements");
        while (each.hasNext()) {
            NutanixPrismElementEndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<NutanixPrismElementEndpoint> buildPrismElements() {
        return this.prismElements != null ? NutanixPlatformSpecFluent.build(this.prismElements) : null;
    }

    public NutanixPrismElementEndpoint buildPrismElement(int index) {
        return this.prismElements.get(index).build();
    }

    public NutanixPrismElementEndpoint buildFirstPrismElement() {
        return this.prismElements.get(0).build();
    }

    public NutanixPrismElementEndpoint buildLastPrismElement() {
        return this.prismElements.get(this.prismElements.size() - 1).build();
    }

    public NutanixPrismElementEndpoint buildMatchingPrismElement(Predicate<NutanixPrismElementEndpointBuilder> predicate) {
        for (NutanixPrismElementEndpointBuilder item : this.prismElements) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPrismElement(Predicate<NutanixPrismElementEndpointBuilder> predicate) {
        for (NutanixPrismElementEndpointBuilder item : this.prismElements) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPrismElements(List<NutanixPrismElementEndpoint> prismElements) {
        if (this.prismElements != null) {
            this._visitables.get((Object)"prismElements").clear();
        }
        if (prismElements != null) {
            this.prismElements = new ArrayList();
            for (NutanixPrismElementEndpoint item : prismElements) {
                this.addToPrismElements(item);
            }
        } else {
            this.prismElements = null;
        }
        return (A)((Object)this);
    }

    public A withPrismElements(NutanixPrismElementEndpoint ... prismElements) {
        if (this.prismElements != null) {
            this.prismElements.clear();
            this._visitables.remove((Object)"prismElements");
        }
        if (prismElements != null) {
            for (NutanixPrismElementEndpoint item : prismElements) {
                this.addToPrismElements(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPrismElements() {
        return this.prismElements != null && !this.prismElements.isEmpty();
    }

    public PrismElementsNested<A> addNewPrismElement() {
        return new PrismElementsNested(-1, null);
    }

    public PrismElementsNested<A> addNewPrismElementLike(NutanixPrismElementEndpoint item) {
        return new PrismElementsNested(-1, item);
    }

    public PrismElementsNested<A> setNewPrismElementLike(int index, NutanixPrismElementEndpoint item) {
        return new PrismElementsNested(index, item);
    }

    public PrismElementsNested<A> editPrismElement(int index) {
        if (this.prismElements.size() <= index) {
            throw new RuntimeException("Can't edit prismElements. Index exceeds size.");
        }
        return this.setNewPrismElementLike(index, this.buildPrismElement(index));
    }

    public PrismElementsNested<A> editFirstPrismElement() {
        if (this.prismElements.size() == 0) {
            throw new RuntimeException("Can't edit first prismElements. The list is empty.");
        }
        return this.setNewPrismElementLike(0, this.buildPrismElement(0));
    }

    public PrismElementsNested<A> editLastPrismElement() {
        int index = this.prismElements.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last prismElements. The list is empty.");
        }
        return this.setNewPrismElementLike(index, this.buildPrismElement(index));
    }

    public PrismElementsNested<A> editMatchingPrismElement(Predicate<NutanixPrismElementEndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.prismElements.size(); ++i) {
            if (!predicate.test(this.prismElements.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching prismElements. No match found.");
        }
        return this.setNewPrismElementLike(index, this.buildPrismElement(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NutanixPlatformSpecFluent that = (NutanixPlatformSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.prismCentral, (Object)that.prismCentral)) {
            return false;
        }
        if (!Objects.equals(this.prismElements, that.prismElements)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prismCentral, this.prismElements, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.prismCentral != null) {
            sb.append("prismCentral:");
            sb.append((Object)((Object)this.prismCentral) + ",");
        }
        if (this.prismElements != null && !this.prismElements.isEmpty()) {
            sb.append("prismElements:");
            sb.append(this.prismElements + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PrismElementsNested<N>
    extends NutanixPrismElementEndpointFluent<PrismElementsNested<N>>
    implements Nested<N> {
        NutanixPrismElementEndpointBuilder builder;
        int index;

        PrismElementsNested(int index, NutanixPrismElementEndpoint item) {
            this.index = index;
            this.builder = new NutanixPrismElementEndpointBuilder(this, item);
        }

        public N and() {
            return (N)NutanixPlatformSpecFluent.this.setToPrismElements(this.index, this.builder.build());
        }

        public N endPrismElement() {
            return this.and();
        }
    }

    public class PrismCentralNested<N>
    extends NutanixPrismEndpointFluent<PrismCentralNested<N>>
    implements Nested<N> {
        NutanixPrismEndpointBuilder builder;

        PrismCentralNested(NutanixPrismEndpoint item) {
            this.builder = new NutanixPrismEndpointBuilder(this, item);
        }

        public N and() {
            return (N)NutanixPlatformSpecFluent.this.withPrismCentral(this.builder.build());
        }

        public N endPrismCentral() {
            return this.and();
        }
    }
}

