package io.fabric8.openshift.api.model.console.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConsolePluginServiceBuilder extends ConsolePluginServiceFluent<ConsolePluginServiceBuilder> implements VisitableBuilder<ConsolePluginService,ConsolePluginServiceBuilder>{
  public ConsolePluginServiceBuilder() {
    this(new ConsolePluginService());
  }
  
  public ConsolePluginServiceBuilder(ConsolePluginServiceFluent<?> fluent) {
    this(fluent, new ConsolePluginService());
  }
  
  public ConsolePluginServiceBuilder(ConsolePluginServiceFluent<?> fluent,ConsolePluginService instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConsolePluginServiceBuilder(ConsolePluginService instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConsolePluginServiceFluent<?> fluent;
  
  public ConsolePluginService build() {
    ConsolePluginService buildable = new ConsolePluginService(fluent.getBasePath(),fluent.getName(),fluent.getNamespace(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}