/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.azure.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.azure.v1.MachinePool;
import io.fabric8.openshift.api.model.hive.azure.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.hive.azure.v1.OSDisk;
import io.fabric8.openshift.api.model.hive.azure.v1.OSDiskBuilder;
import io.fabric8.openshift.api.model.hive.azure.v1.OSDiskFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MachinePoolFluentImpl<A extends MachinePoolFluent<A>>
extends BaseFluent<A>
implements MachinePoolFluent<A> {
    private OSDiskBuilder osDisk;
    private String type;
    private List<String> zones = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public MachinePoolFluentImpl() {
    }

    public MachinePoolFluentImpl(MachinePool instance) {
        this.withOsDisk(instance.getOsDisk());
        this.withType(instance.getType());
        this.withZones(instance.getZones());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public OSDisk getOsDisk() {
        return this.osDisk != null ? this.osDisk.build() : null;
    }

    @Override
    public OSDisk buildOsDisk() {
        return this.osDisk != null ? this.osDisk.build() : null;
    }

    @Override
    public A withOsDisk(OSDisk osDisk) {
        this._visitables.get((Object)"osDisk").remove(this.osDisk);
        if (osDisk != null) {
            this.osDisk = new OSDiskBuilder(osDisk);
            this._visitables.get((Object)"osDisk").add(this.osDisk);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOsDisk() {
        return this.osDisk != null;
    }

    @Override
    public A withNewOsDisk(Integer diskSizeGB) {
        return this.withOsDisk(new OSDisk(diskSizeGB));
    }

    @Override
    public MachinePoolFluent.OsDiskNested<A> withNewOsDisk() {
        return new OsDiskNestedImpl();
    }

    @Override
    public MachinePoolFluent.OsDiskNested<A> withNewOsDiskLike(OSDisk item) {
        return new OsDiskNestedImpl(item);
    }

    @Override
    public MachinePoolFluent.OsDiskNested<A> editOsDisk() {
        return this.withNewOsDiskLike(this.getOsDisk());
    }

    @Override
    public MachinePoolFluent.OsDiskNested<A> editOrNewOsDisk() {
        return this.withNewOsDiskLike(this.getOsDisk() != null ? this.getOsDisk() : new OSDiskBuilder().build());
    }

    @Override
    public MachinePoolFluent.OsDiskNested<A> editOrNewOsDiskLike(OSDisk item) {
        return this.withNewOsDiskLike(this.getOsDisk() != null ? this.getOsDisk() : item);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    @Deprecated
    public A withNewType(String arg0) {
        return this.withType(new String(arg0));
    }

    @Override
    public A addToZones(Integer index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)this;
    }

    @Override
    public A setToZones(Integer index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)this;
    }

    @Override
    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromZones(String ... items) {
        for (String item : items) {
            if (this.zones == null) continue;
            this.zones.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromZones(Collection<String> items) {
        for (String item : items) {
            if (this.zones == null) continue;
            this.zones.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getZones() {
        return this.zones;
    }

    @Override
    public String getZone(Integer index) {
        return this.zones.get(index);
    }

    @Override
    public String getFirstZone() {
        return this.zones.get(0);
    }

    @Override
    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    @Override
    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)this;
    }

    @Override
    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    @Override
    public A addNewZone(String arg0) {
        return this.addToZones(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachinePoolFluentImpl that = (MachinePoolFluentImpl)o;
        if (this.osDisk != null ? !this.osDisk.equals(that.osDisk) : that.osDisk != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.zones != null ? !this.zones.equals(that.zones) : that.zones != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.osDisk, this.type, this.zones, this.additionalProperties, super.hashCode());
    }

    public class OsDiskNestedImpl<N>
    extends OSDiskFluentImpl<MachinePoolFluent.OsDiskNested<N>>
    implements MachinePoolFluent.OsDiskNested<N>,
    Nested<N> {
        OSDiskBuilder builder;

        OsDiskNestedImpl(OSDisk item) {
            this.builder = new OSDiskBuilder(this, item);
        }

        OsDiskNestedImpl() {
            this.builder = new OSDiskBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluentImpl.this.withOsDisk(this.builder.build());
        }

        @Override
        public N endOsDisk() {
            return this.and();
        }
    }
}

