package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CertificateBundleSpecBuilder extends CertificateBundleSpecFluent<CertificateBundleSpecBuilder> implements VisitableBuilder<CertificateBundleSpec,CertificateBundleSpecBuilder>{
  public CertificateBundleSpecBuilder() {
    this(new CertificateBundleSpec());
  }
  
  public CertificateBundleSpecBuilder(CertificateBundleSpecFluent<?> fluent) {
    this(fluent, new CertificateBundleSpec());
  }
  
  public CertificateBundleSpecBuilder(CertificateBundleSpecFluent<?> fluent,CertificateBundleSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CertificateBundleSpecBuilder(CertificateBundleSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CertificateBundleSpecFluent<?> fluent;
  
  public CertificateBundleSpec build() {
    CertificateBundleSpec buildable = new CertificateBundleSpec(fluent.buildCertificateSecretRef(),fluent.getGenerate(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}