package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterIngressBuilder extends ClusterIngressFluent<ClusterIngressBuilder> implements VisitableBuilder<ClusterIngress,ClusterIngressBuilder>{
  public ClusterIngressBuilder() {
    this(new ClusterIngress());
  }
  
  public ClusterIngressBuilder(ClusterIngressFluent<?> fluent) {
    this(fluent, new ClusterIngress());
  }
  
  public ClusterIngressBuilder(ClusterIngressFluent<?> fluent,ClusterIngress instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterIngressBuilder(ClusterIngress instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterIngressFluent<?> fluent;
  
  public ClusterIngress build() {
    ClusterIngress buildable = new ClusterIngress(fluent.getDomain(),fluent.getHttpErrorCodePages(),fluent.getName(),fluent.buildNamespaceSelector(),fluent.buildRouteSelector(),fluent.getServingCertificate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}