package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ControllersConfigBuilder extends ControllersConfigFluent<ControllersConfigBuilder> implements VisitableBuilder<ControllersConfig,ControllersConfigBuilder>{
  public ControllersConfigBuilder() {
    this(new ControllersConfig());
  }
  
  public ControllersConfigBuilder(ControllersConfigFluent<?> fluent) {
    this(fluent, new ControllersConfig());
  }
  
  public ControllersConfigBuilder(ControllersConfigFluent<?> fluent,ControllersConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ControllersConfigBuilder(ControllersConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ControllersConfigFluent<?> fluent;
  
  public ControllersConfig build() {
    ControllersConfig buildable = new ControllersConfig(fluent.buildControllers(),fluent.buildDefault());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}