package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ManageDNSConfigFluent<A extends ManageDNSConfigFluent<A>> extends BaseFluent<A>{
  public ManageDNSConfigFluent() {
  }
  
  public ManageDNSConfigFluent(ManageDNSConfig instance) {
    this.copyInstance(instance);
  }
  private ManageDNSAWSConfigBuilder aws;
  private ManageDNSAzureConfigBuilder azure;
  private List<String> domains = new ArrayList<String>();
  private ManageDNSGCPConfigBuilder gcp;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ManageDNSConfig instance) {
    instance = (instance != null ? instance : new ManageDNSConfig());
    if (instance != null) {
          this.withAws(instance.getAws());
          this.withAzure(instance.getAzure());
          this.withDomains(instance.getDomains());
          this.withGcp(instance.getGcp());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ManageDNSAWSConfig buildAws() {
    return this.aws != null ? this.aws.build() : null;
  }
  
  public A withAws(ManageDNSAWSConfig aws) {
    this._visitables.remove("aws");
    if (aws != null) {
        this.aws = new ManageDNSAWSConfigBuilder(aws);
        this._visitables.get("aws").add(this.aws);
    } else {
        this.aws = null;
        this._visitables.get("aws").remove(this.aws);
    }
    return (A) this;
  }
  
  public boolean hasAws() {
    return this.aws != null;
  }
  
  public AwsNested<A> withNewAws() {
    return new AwsNested(null);
  }
  
  public AwsNested<A> withNewAwsLike(ManageDNSAWSConfig item) {
    return new AwsNested(item);
  }
  
  public AwsNested<A> editAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(null));
  }
  
  public AwsNested<A> editOrNewAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(new ManageDNSAWSConfigBuilder().build()));
  }
  
  public AwsNested<A> editOrNewAwsLike(ManageDNSAWSConfig item) {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(item));
  }
  
  public ManageDNSAzureConfig buildAzure() {
    return this.azure != null ? this.azure.build() : null;
  }
  
  public A withAzure(ManageDNSAzureConfig azure) {
    this._visitables.remove("azure");
    if (azure != null) {
        this.azure = new ManageDNSAzureConfigBuilder(azure);
        this._visitables.get("azure").add(this.azure);
    } else {
        this.azure = null;
        this._visitables.get("azure").remove(this.azure);
    }
    return (A) this;
  }
  
  public boolean hasAzure() {
    return this.azure != null;
  }
  
  public AzureNested<A> withNewAzure() {
    return new AzureNested(null);
  }
  
  public AzureNested<A> withNewAzureLike(ManageDNSAzureConfig item) {
    return new AzureNested(item);
  }
  
  public AzureNested<A> editAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(null));
  }
  
  public AzureNested<A> editOrNewAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(new ManageDNSAzureConfigBuilder().build()));
  }
  
  public AzureNested<A> editOrNewAzureLike(ManageDNSAzureConfig item) {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(item));
  }
  
  public A addToDomains(int index,String item) {
    if (this.domains == null) {this.domains = new ArrayList<String>();}
    this.domains.add(index, item);
    return (A)this;
  }
  
  public A setToDomains(int index,String item) {
    if (this.domains == null) {this.domains = new ArrayList<String>();}
    this.domains.set(index, item); return (A)this;
  }
  
  public A addToDomains(java.lang.String... items) {
    if (this.domains == null) {this.domains = new ArrayList<String>();}
    for (String item : items) {this.domains.add(item);} return (A)this;
  }
  
  public A addAllToDomains(Collection<String> items) {
    if (this.domains == null) {this.domains = new ArrayList<String>();}
    for (String item : items) {this.domains.add(item);} return (A)this;
  }
  
  public A removeFromDomains(java.lang.String... items) {
    if (this.domains == null) return (A)this;
    for (String item : items) { this.domains.remove(item);} return (A)this;
  }
  
  public A removeAllFromDomains(Collection<String> items) {
    if (this.domains == null) return (A)this;
    for (String item : items) { this.domains.remove(item);} return (A)this;
  }
  
  public List<String> getDomains() {
    return this.domains;
  }
  
  public String getDomain(int index) {
    return this.domains.get(index);
  }
  
  public String getFirstDomain() {
    return this.domains.get(0);
  }
  
  public String getLastDomain() {
    return this.domains.get(domains.size() - 1);
  }
  
  public String getMatchingDomain(Predicate<String> predicate) {
      for (String item : domains) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingDomain(Predicate<String> predicate) {
      for (String item : domains) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDomains(List<String> domains) {
    if (domains != null) {
        this.domains = new ArrayList();
        for (String item : domains) {
          this.addToDomains(item);
        }
    } else {
      this.domains = null;
    }
    return (A) this;
  }
  
  public A withDomains(java.lang.String... domains) {
    if (this.domains != null) {
        this.domains.clear();
        _visitables.remove("domains");
    }
    if (domains != null) {
      for (String item : domains) {
        this.addToDomains(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDomains() {
    return this.domains != null && !this.domains.isEmpty();
  }
  
  public ManageDNSGCPConfig buildGcp() {
    return this.gcp != null ? this.gcp.build() : null;
  }
  
  public A withGcp(ManageDNSGCPConfig gcp) {
    this._visitables.remove("gcp");
    if (gcp != null) {
        this.gcp = new ManageDNSGCPConfigBuilder(gcp);
        this._visitables.get("gcp").add(this.gcp);
    } else {
        this.gcp = null;
        this._visitables.get("gcp").remove(this.gcp);
    }
    return (A) this;
  }
  
  public boolean hasGcp() {
    return this.gcp != null;
  }
  
  public GcpNested<A> withNewGcp() {
    return new GcpNested(null);
  }
  
  public GcpNested<A> withNewGcpLike(ManageDNSGCPConfig item) {
    return new GcpNested(item);
  }
  
  public GcpNested<A> editGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(null));
  }
  
  public GcpNested<A> editOrNewGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(new ManageDNSGCPConfigBuilder().build()));
  }
  
  public GcpNested<A> editOrNewGcpLike(ManageDNSGCPConfig item) {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ManageDNSConfigFluent that = (ManageDNSConfigFluent) o;
    if (!java.util.Objects.equals(aws, that.aws)) return false;
    if (!java.util.Objects.equals(azure, that.azure)) return false;
    if (!java.util.Objects.equals(domains, that.domains)) return false;
    if (!java.util.Objects.equals(gcp, that.gcp)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(aws,  azure,  domains,  gcp,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (azure != null) { sb.append("azure:"); sb.append(azure + ","); }
    if (domains != null && !domains.isEmpty()) { sb.append("domains:"); sb.append(domains + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AwsNested<N> extends ManageDNSAWSConfigFluent<AwsNested<N>> implements Nested<N>{
    AwsNested(ManageDNSAWSConfig item) {
      this.builder = new ManageDNSAWSConfigBuilder(this, item);
    }
    ManageDNSAWSConfigBuilder builder;
    
    public N and() {
      return (N) ManageDNSConfigFluent.this.withAws(builder.build());
    }
    
    public N endAws() {
      return and();
    }
    
  
  }
  public class AzureNested<N> extends ManageDNSAzureConfigFluent<AzureNested<N>> implements Nested<N>{
    AzureNested(ManageDNSAzureConfig item) {
      this.builder = new ManageDNSAzureConfigBuilder(this, item);
    }
    ManageDNSAzureConfigBuilder builder;
    
    public N and() {
      return (N) ManageDNSConfigFluent.this.withAzure(builder.build());
    }
    
    public N endAzure() {
      return and();
    }
    
  
  }
  public class GcpNested<N> extends ManageDNSGCPConfigFluent<GcpNested<N>> implements Nested<N>{
    GcpNested(ManageDNSGCPConfig item) {
      this.builder = new ManageDNSGCPConfigBuilder(this, item);
    }
    ManageDNSGCPConfigBuilder builder;
    
    public N and() {
      return (N) ManageDNSConfigFluent.this.withGcp(builder.build());
    }
    
    public N endGcp() {
      return and();
    }
    
  
  }

}