package io.fabric8.openshift.api.model.hive.ovirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DiskBuilder extends DiskFluent<DiskBuilder> implements VisitableBuilder<Disk,DiskBuilder>{
  public DiskBuilder() {
    this(new Disk());
  }
  
  public DiskBuilder(DiskFluent<?> fluent) {
    this(fluent, new Disk());
  }
  
  public DiskBuilder(DiskFluent<?> fluent,Disk instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DiskBuilder(Disk instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DiskFluent<?> fluent;
  
  public Disk build() {
    Disk buildable = new Disk(fluent.getSizeGB());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}