package io.fabric8.openshift.api.model.installer.vsphere.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class FailureDomainFluent<A extends FailureDomainFluent<A>> extends BaseFluent<A>{
  public FailureDomainFluent() {
  }
  
  public FailureDomainFluent(FailureDomain instance) {
    this.copyInstance(instance);
  }
  private String name;
  private String region;
  private String server;
  private TopologyBuilder topology;
  private String zone;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(FailureDomain instance) {
    instance = (instance != null ? instance : new FailureDomain());
    if (instance != null) {
          this.withName(instance.getName());
          this.withRegion(instance.getRegion());
          this.withServer(instance.getServer());
          this.withTopology(instance.getTopology());
          this.withZone(instance.getZone());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region = region;
    return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public String getServer() {
    return this.server;
  }
  
  public A withServer(String server) {
    this.server = server;
    return (A) this;
  }
  
  public boolean hasServer() {
    return this.server != null;
  }
  
  public Topology buildTopology() {
    return this.topology != null ? this.topology.build() : null;
  }
  
  public A withTopology(Topology topology) {
    this._visitables.remove("topology");
    if (topology != null) {
        this.topology = new TopologyBuilder(topology);
        this._visitables.get("topology").add(this.topology);
    } else {
        this.topology = null;
        this._visitables.get("topology").remove(this.topology);
    }
    return (A) this;
  }
  
  public boolean hasTopology() {
    return this.topology != null;
  }
  
  public TopologyNested<A> withNewTopology() {
    return new TopologyNested(null);
  }
  
  public TopologyNested<A> withNewTopologyLike(Topology item) {
    return new TopologyNested(item);
  }
  
  public TopologyNested<A> editTopology() {
    return withNewTopologyLike(java.util.Optional.ofNullable(buildTopology()).orElse(null));
  }
  
  public TopologyNested<A> editOrNewTopology() {
    return withNewTopologyLike(java.util.Optional.ofNullable(buildTopology()).orElse(new TopologyBuilder().build()));
  }
  
  public TopologyNested<A> editOrNewTopologyLike(Topology item) {
    return withNewTopologyLike(java.util.Optional.ofNullable(buildTopology()).orElse(item));
  }
  
  public String getZone() {
    return this.zone;
  }
  
  public A withZone(String zone) {
    this.zone = zone;
    return (A) this;
  }
  
  public boolean hasZone() {
    return this.zone != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    FailureDomainFluent that = (FailureDomainFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(region, that.region)) return false;
    if (!java.util.Objects.equals(server, that.server)) return false;
    if (!java.util.Objects.equals(topology, that.topology)) return false;
    if (!java.util.Objects.equals(zone, that.zone)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  region,  server,  topology,  zone,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (server != null) { sb.append("server:"); sb.append(server + ","); }
    if (topology != null) { sb.append("topology:"); sb.append(topology + ","); }
    if (zone != null) { sb.append("zone:"); sb.append(zone + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TopologyNested<N> extends TopologyFluent<TopologyNested<N>> implements Nested<N>{
    TopologyNested(Topology item) {
      this.builder = new TopologyBuilder(this, item);
    }
    TopologyBuilder builder;
    
    public N and() {
      return (N) FailureDomainFluent.this.withTopology(builder.build());
    }
    
    public N endTopology() {
      return and();
    }
    
  
  }

}