package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineSetStatusBuilder extends MachineSetStatusFluent<MachineSetStatusBuilder> implements VisitableBuilder<MachineSetStatus,MachineSetStatusBuilder>{
  public MachineSetStatusBuilder() {
    this(new MachineSetStatus());
  }
  
  public MachineSetStatusBuilder(MachineSetStatusFluent<?> fluent) {
    this(fluent, new MachineSetStatus());
  }
  
  public MachineSetStatusBuilder(MachineSetStatusFluent<?> fluent,MachineSetStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineSetStatusBuilder(MachineSetStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineSetStatusFluent<?> fluent;
  
  public MachineSetStatus build() {
    MachineSetStatus buildable = new MachineSetStatus(fluent.getAvailableReplicas(),fluent.getErrorMessage(),fluent.getErrorReason(),fluent.getFullyLabeledReplicas(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}