/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.Condition;
import io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.ConditionFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.LastOperation;
import io.fabric8.openshift.api.model.machine.v1beta1.LastOperationBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.LastOperationFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachineStatusFluent<A extends MachineStatusFluent<A>>
extends BaseFluent<A> {
    private List<NodeAddress> addresses = new ArrayList<NodeAddress>();
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private String errorMessage;
    private String errorReason;
    private LastOperationBuilder lastOperation;
    private String lastUpdated;
    private ObjectReferenceBuilder nodeRef;
    private String phase;
    private Map<String, Object> providerStatus;
    private Map<String, Object> additionalProperties;

    public MachineStatusFluent() {
    }

    public MachineStatusFluent(MachineStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineStatus instance) {
        MachineStatus machineStatus = instance = instance != null ? instance : new MachineStatus();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withConditions(instance.getConditions());
            this.withErrorMessage(instance.getErrorMessage());
            this.withErrorReason(instance.getErrorReason());
            this.withLastOperation(instance.getLastOperation());
            this.withLastUpdated(instance.getLastUpdated());
            this.withNodeRef(instance.getNodeRef());
            this.withPhase(instance.getPhase());
            this.withProviderStatus(instance.getProviderStatus());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAddresses(int index, NodeAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<NodeAddress>();
        }
        this.addresses.add(index, item);
        return (A)((Object)this);
    }

    public A setToAddresses(int index, NodeAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<NodeAddress>();
        }
        this.addresses.set(index, item);
        return (A)((Object)this);
    }

    public A addToAddresses(NodeAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<NodeAddress>();
        }
        for (NodeAddress item : items) {
            this.addresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAddresses(Collection<NodeAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<NodeAddress>();
        }
        for (NodeAddress item : items) {
            this.addresses.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(NodeAddress ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (NodeAddress item : items) {
            this.addresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAddresses(Collection<NodeAddress> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (NodeAddress item : items) {
            this.addresses.remove(item);
        }
        return (A)((Object)this);
    }

    public List<NodeAddress> getAddresses() {
        return this.addresses;
    }

    public NodeAddress getAddress(int index) {
        return this.addresses.get(index);
    }

    public NodeAddress getFirstAddress() {
        return this.addresses.get(0);
    }

    public NodeAddress getLastAddress() {
        return this.addresses.get(this.addresses.size() - 1);
    }

    public NodeAddress getMatchingAddress(Predicate<NodeAddress> predicate) {
        for (NodeAddress item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAddress(Predicate<NodeAddress> predicate) {
        for (NodeAddress item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAddresses(List<NodeAddress> addresses) {
        if (addresses != null) {
            this.addresses = new ArrayList<NodeAddress>();
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(NodeAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public A addNewAddress(String address, String type) {
        return this.addToAddresses(new NodeAddress(address, type));
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Condition> buildConditions() {
        return this.conditions != null ? MachineStatusFluent.build(this.conditions) : null;
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public A withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return (A)((Object)this);
    }

    public boolean hasErrorMessage() {
        return this.errorMessage != null;
    }

    public String getErrorReason() {
        return this.errorReason;
    }

    public A withErrorReason(String errorReason) {
        this.errorReason = errorReason;
        return (A)((Object)this);
    }

    public boolean hasErrorReason() {
        return this.errorReason != null;
    }

    public LastOperation buildLastOperation() {
        return this.lastOperation != null ? this.lastOperation.build() : null;
    }

    public A withLastOperation(LastOperation lastOperation) {
        this._visitables.remove((Object)"lastOperation");
        if (lastOperation != null) {
            this.lastOperation = new LastOperationBuilder(lastOperation);
            this._visitables.get((Object)"lastOperation").add(this.lastOperation);
        } else {
            this.lastOperation = null;
            this._visitables.get((Object)"lastOperation").remove((Object)this.lastOperation);
        }
        return (A)((Object)this);
    }

    public boolean hasLastOperation() {
        return this.lastOperation != null;
    }

    public A withNewLastOperation(String description, String lastUpdated, String state, String type) {
        return this.withLastOperation(new LastOperation(description, lastUpdated, state, type));
    }

    public LastOperationNested<A> withNewLastOperation() {
        return new LastOperationNested(null);
    }

    public LastOperationNested<A> withNewLastOperationLike(LastOperation item) {
        return new LastOperationNested(item);
    }

    public LastOperationNested<A> editLastOperation() {
        return this.withNewLastOperationLike(Optional.ofNullable(this.buildLastOperation()).orElse(null));
    }

    public LastOperationNested<A> editOrNewLastOperation() {
        return this.withNewLastOperationLike(Optional.ofNullable(this.buildLastOperation()).orElse(new LastOperationBuilder().build()));
    }

    public LastOperationNested<A> editOrNewLastOperationLike(LastOperation item) {
        return this.withNewLastOperationLike(Optional.ofNullable(this.buildLastOperation()).orElse(item));
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public A withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return (A)((Object)this);
    }

    public boolean hasLastUpdated() {
        return this.lastUpdated != null;
    }

    public ObjectReference buildNodeRef() {
        return this.nodeRef != null ? this.nodeRef.build() : null;
    }

    public A withNodeRef(ObjectReference nodeRef) {
        this._visitables.remove((Object)"nodeRef");
        if (nodeRef != null) {
            this.nodeRef = new ObjectReferenceBuilder(nodeRef);
            this._visitables.get((Object)"nodeRef").add(this.nodeRef);
        } else {
            this.nodeRef = null;
            this._visitables.get((Object)"nodeRef").remove(this.nodeRef);
        }
        return (A)((Object)this);
    }

    public boolean hasNodeRef() {
        return this.nodeRef != null;
    }

    public NodeRefNested<A> withNewNodeRef() {
        return new NodeRefNested(null);
    }

    public NodeRefNested<A> withNewNodeRefLike(ObjectReference item) {
        return new NodeRefNested(item);
    }

    public NodeRefNested<A> editNodeRef() {
        return this.withNewNodeRefLike(Optional.ofNullable(this.buildNodeRef()).orElse(null));
    }

    public NodeRefNested<A> editOrNewNodeRef() {
        return this.withNewNodeRefLike(Optional.ofNullable(this.buildNodeRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public NodeRefNested<A> editOrNewNodeRefLike(ObjectReference item) {
        return this.withNewNodeRefLike(Optional.ofNullable(this.buildNodeRef()).orElse(item));
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)((Object)this);
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public A addToProviderStatus(String key, Object value) {
        if (this.providerStatus == null && key != null && value != null) {
            this.providerStatus = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.providerStatus.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToProviderStatus(Map<String, Object> map) {
        if (this.providerStatus == null && map != null) {
            this.providerStatus = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.providerStatus.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromProviderStatus(String key) {
        if (this.providerStatus == null) {
            return (A)((Object)this);
        }
        if (key != null && this.providerStatus != null) {
            this.providerStatus.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromProviderStatus(Map<String, Object> map) {
        if (this.providerStatus == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.providerStatus == null) continue;
                this.providerStatus.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getProviderStatus() {
        return this.providerStatus;
    }

    public <K, V> A withProviderStatus(Map<String, Object> providerStatus) {
        this.providerStatus = providerStatus == null ? null : new LinkedHashMap<String, Object>(providerStatus);
        return (A)((Object)this);
    }

    public boolean hasProviderStatus() {
        return this.providerStatus != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineStatusFluent that = (MachineStatusFluent)((Object)o);
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.errorMessage, that.errorMessage)) {
            return false;
        }
        if (!Objects.equals(this.errorReason, that.errorReason)) {
            return false;
        }
        if (!Objects.equals((Object)this.lastOperation, (Object)that.lastOperation)) {
            return false;
        }
        if (!Objects.equals(this.lastUpdated, that.lastUpdated)) {
            return false;
        }
        if (!Objects.equals(this.nodeRef, that.nodeRef)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.providerStatus, that.providerStatus)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addresses, this.conditions, this.errorMessage, this.errorReason, this.lastOperation, this.lastUpdated, this.nodeRef, this.phase, this.providerStatus, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.errorMessage != null) {
            sb.append("errorMessage:");
            sb.append(this.errorMessage + ",");
        }
        if (this.errorReason != null) {
            sb.append("errorReason:");
            sb.append(this.errorReason + ",");
        }
        if (this.lastOperation != null) {
            sb.append("lastOperation:");
            sb.append((Object)((Object)this.lastOperation) + ",");
        }
        if (this.lastUpdated != null) {
            sb.append("lastUpdated:");
            sb.append(this.lastUpdated + ",");
        }
        if (this.nodeRef != null) {
            sb.append("nodeRef:");
            sb.append(this.nodeRef + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.providerStatus != null && !this.providerStatus.isEmpty()) {
            sb.append("providerStatus:");
            sb.append(this.providerStatus + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NodeRefNested<N>
    extends ObjectReferenceFluent<NodeRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        NodeRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)MachineStatusFluent.this.withNodeRef(this.builder.build());
        }

        public N endNodeRef() {
            return this.and();
        }
    }

    public class LastOperationNested<N>
    extends LastOperationFluent<LastOperationNested<N>>
    implements Nested<N> {
        LastOperationBuilder builder;

        LastOperationNested(LastOperation item) {
            this.builder = new LastOperationBuilder(this, item);
        }

        public N and() {
            return (N)MachineStatusFluent.this.withLastOperation(this.builder.build());
        }

        public N endLastOperation() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNested(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        public N and() {
            return (N)MachineStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

