package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StorageBuilder extends StorageFluent<StorageBuilder> implements VisitableBuilder<Storage,StorageBuilder>{
  public StorageBuilder() {
    this(new Storage());
  }
  
  public StorageBuilder(StorageFluent<?> fluent) {
    this(fluent, new Storage());
  }
  
  public StorageBuilder(StorageFluent<?> fluent,Storage instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StorageBuilder(Storage instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StorageFluent<?> fluent;
  
  public Storage build() {
    Storage buildable = new Storage(fluent.getAlternateNames(),fluent.getHctl(),fluent.getModel(),fluent.getName(),fluent.getRotational(),fluent.getSerialNumber(),fluent.getSizeBytes(),fluent.getType(),fluent.getVendor(),fluent.getWwn(),fluent.getWwnVendorExtension(),fluent.getWwnWithExtension());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}