/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataIPv6DHCP;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataRoutev6;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataRoutev6Builder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataRoutev6Fluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkDataIPv6DHCPFluent<A extends NetworkDataIPv6DHCPFluent<A>>
extends BaseFluent<A> {
    private String id;
    private String link;
    private ArrayList<NetworkDataRoutev6Builder> routes = new ArrayList();
    private Map<String, Object> additionalProperties;

    public NetworkDataIPv6DHCPFluent() {
    }

    public NetworkDataIPv6DHCPFluent(NetworkDataIPv6DHCP instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkDataIPv6DHCP instance) {
        NetworkDataIPv6DHCP networkDataIPv6DHCP = instance = instance != null ? instance : new NetworkDataIPv6DHCP();
        if (instance != null) {
            this.withId(instance.getId());
            this.withLink(instance.getLink());
            this.withRoutes(instance.getRoutes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getId() {
        return this.id;
    }

    public A withId(String id) {
        this.id = id;
        return (A)((Object)this);
    }

    public boolean hasId() {
        return this.id != null;
    }

    public String getLink() {
        return this.link;
    }

    public A withLink(String link) {
        this.link = link;
        return (A)((Object)this);
    }

    public boolean hasLink() {
        return this.link != null;
    }

    public A addToRoutes(int index, NetworkDataRoutev6 item) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        NetworkDataRoutev6Builder builder = new NetworkDataRoutev6Builder(item);
        if (index < 0 || index >= this.routes.size()) {
            this._visitables.get((Object)"routes").add(builder);
            this.routes.add(builder);
        } else {
            this._visitables.get((Object)"routes").add(index, builder);
            this.routes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRoutes(int index, NetworkDataRoutev6 item) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        NetworkDataRoutev6Builder builder = new NetworkDataRoutev6Builder(item);
        if (index < 0 || index >= this.routes.size()) {
            this._visitables.get((Object)"routes").add(builder);
            this.routes.add(builder);
        } else {
            this._visitables.get((Object)"routes").set(index, builder);
            this.routes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRoutes(NetworkDataRoutev6 ... items) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        for (NetworkDataRoutev6 item : items) {
            NetworkDataRoutev6Builder builder = new NetworkDataRoutev6Builder(item);
            this._visitables.get((Object)"routes").add(builder);
            this.routes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRoutes(Collection<NetworkDataRoutev6> items) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        for (NetworkDataRoutev6 item : items) {
            NetworkDataRoutev6Builder builder = new NetworkDataRoutev6Builder(item);
            this._visitables.get((Object)"routes").add(builder);
            this.routes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRoutes(NetworkDataRoutev6 ... items) {
        if (this.routes == null) {
            return (A)((Object)this);
        }
        for (NetworkDataRoutev6 item : items) {
            NetworkDataRoutev6Builder builder = new NetworkDataRoutev6Builder(item);
            this._visitables.get((Object)"routes").remove((Object)builder);
            this.routes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRoutes(Collection<NetworkDataRoutev6> items) {
        if (this.routes == null) {
            return (A)((Object)this);
        }
        for (NetworkDataRoutev6 item : items) {
            NetworkDataRoutev6Builder builder = new NetworkDataRoutev6Builder(item);
            this._visitables.get((Object)"routes").remove((Object)builder);
            this.routes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRoutes(Predicate<NetworkDataRoutev6Builder> predicate) {
        if (this.routes == null) {
            return (A)((Object)this);
        }
        Iterator<NetworkDataRoutev6Builder> each = this.routes.iterator();
        List visitables = this._visitables.get((Object)"routes");
        while (each.hasNext()) {
            NetworkDataRoutev6Builder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<NetworkDataRoutev6> buildRoutes() {
        return this.routes != null ? NetworkDataIPv6DHCPFluent.build(this.routes) : null;
    }

    public NetworkDataRoutev6 buildRoute(int index) {
        return this.routes.get(index).build();
    }

    public NetworkDataRoutev6 buildFirstRoute() {
        return this.routes.get(0).build();
    }

    public NetworkDataRoutev6 buildLastRoute() {
        return this.routes.get(this.routes.size() - 1).build();
    }

    public NetworkDataRoutev6 buildMatchingRoute(Predicate<NetworkDataRoutev6Builder> predicate) {
        for (NetworkDataRoutev6Builder item : this.routes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRoute(Predicate<NetworkDataRoutev6Builder> predicate) {
        for (NetworkDataRoutev6Builder item : this.routes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRoutes(List<NetworkDataRoutev6> routes) {
        if (this.routes != null) {
            this._visitables.get((Object)"routes").clear();
        }
        if (routes != null) {
            this.routes = new ArrayList();
            for (NetworkDataRoutev6 item : routes) {
                this.addToRoutes(item);
            }
        } else {
            this.routes = null;
        }
        return (A)((Object)this);
    }

    public A withRoutes(NetworkDataRoutev6 ... routes) {
        if (this.routes != null) {
            this.routes.clear();
            this._visitables.remove((Object)"routes");
        }
        if (routes != null) {
            for (NetworkDataRoutev6 item : routes) {
                this.addToRoutes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRoutes() {
        return this.routes != null && !this.routes.isEmpty();
    }

    public RoutesNested<A> addNewRoute() {
        return new RoutesNested(-1, null);
    }

    public RoutesNested<A> addNewRouteLike(NetworkDataRoutev6 item) {
        return new RoutesNested(-1, item);
    }

    public RoutesNested<A> setNewRouteLike(int index, NetworkDataRoutev6 item) {
        return new RoutesNested(index, item);
    }

    public RoutesNested<A> editRoute(int index) {
        if (this.routes.size() <= index) {
            throw new RuntimeException("Can't edit routes. Index exceeds size.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public RoutesNested<A> editFirstRoute() {
        if (this.routes.size() == 0) {
            throw new RuntimeException("Can't edit first routes. The list is empty.");
        }
        return this.setNewRouteLike(0, this.buildRoute(0));
    }

    public RoutesNested<A> editLastRoute() {
        int index = this.routes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last routes. The list is empty.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public RoutesNested<A> editMatchingRoute(Predicate<NetworkDataRoutev6Builder> predicate) {
        int index = -1;
        for (int i = 0; i < this.routes.size(); ++i) {
            if (!predicate.test(this.routes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching routes. No match found.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkDataIPv6DHCPFluent that = (NetworkDataIPv6DHCPFluent)((Object)o);
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.link, that.link)) {
            return false;
        }
        if (!Objects.equals(this.routes, that.routes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.link, this.routes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id + ",");
        }
        if (this.link != null) {
            sb.append("link:");
            sb.append(this.link + ",");
        }
        if (this.routes != null && !this.routes.isEmpty()) {
            sb.append("routes:");
            sb.append(this.routes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RoutesNested<N>
    extends NetworkDataRoutev6Fluent<RoutesNested<N>>
    implements Nested<N> {
        NetworkDataRoutev6Builder builder;
        int index;

        RoutesNested(int index, NetworkDataRoutev6 item) {
            this.index = index;
            this.builder = new NetworkDataRoutev6Builder(this, item);
        }

        public N and() {
            return (N)NetworkDataIPv6DHCPFluent.this.setToRoutes(this.index, this.builder.build());
        }

        public N endRoute() {
            return this.and();
        }
    }
}

