/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.QuerySpec;
import io.fabric8.openshift.api.model.monitoring.v1.QuerySpecFluent;
import io.fabric8.openshift.api.model.monitoring.v1.QuerySpecFluentImpl;
import java.util.Objects;

public class QuerySpecBuilder
extends QuerySpecFluentImpl<QuerySpecBuilder>
implements VisitableBuilder<QuerySpec, QuerySpecBuilder> {
    QuerySpecFluent<?> fluent;
    Boolean validationEnabled;

    public QuerySpecBuilder() {
        this(false);
    }

    public QuerySpecBuilder(Boolean validationEnabled) {
        this(new QuerySpec(), validationEnabled);
    }

    public QuerySpecBuilder(QuerySpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public QuerySpecBuilder(QuerySpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new QuerySpec(), validationEnabled);
    }

    public QuerySpecBuilder(QuerySpecFluent<?> fluent, QuerySpec instance) {
        this(fluent, instance, false);
    }

    public QuerySpecBuilder(QuerySpecFluent<?> fluent, QuerySpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLookbackDelta(instance.getLookbackDelta());
        fluent.withMaxConcurrency(instance.getMaxConcurrency());
        fluent.withMaxSamples(instance.getMaxSamples());
        fluent.withTimeout(instance.getTimeout());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public QuerySpecBuilder(QuerySpec instance) {
        this(instance, (Boolean)false);
    }

    public QuerySpecBuilder(QuerySpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLookbackDelta(instance.getLookbackDelta());
        this.withMaxConcurrency(instance.getMaxConcurrency());
        this.withMaxSamples(instance.getMaxSamples());
        this.withTimeout(instance.getTimeout());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public QuerySpec build() {
        QuerySpec buildable = new QuerySpec(this.fluent.getLookbackDelta(), this.fluent.getMaxConcurrency(), this.fluent.getMaxSamples(), this.fluent.getTimeout());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QuerySpecBuilder that = (QuerySpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

