/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.openshift.api.model.monitoring.v1.AttachMetadata;
import io.fabric8.openshift.api.model.monitoring.v1.AttachMetadataBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.AttachMetadataFluent;
import io.fabric8.openshift.api.model.monitoring.v1.Endpoint;
import io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent;
import io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector;
import io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorFluent;
import io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ServiceMonitorSpecFluent<A extends ServiceMonitorSpecFluent<A>>
extends BaseFluent<A> {
    private AttachMetadataBuilder attachMetadata;
    private ArrayList<EndpointBuilder> endpoints = new ArrayList();
    private String jobLabel;
    private Long keepDroppedTargets;
    private Long labelLimit;
    private Long labelNameLengthLimit;
    private Long labelValueLengthLimit;
    private NamespaceSelectorBuilder namespaceSelector;
    private List<String> podTargetLabels = new ArrayList<String>();
    private Long sampleLimit;
    private LabelSelectorBuilder selector;
    private List<String> targetLabels = new ArrayList<String>();
    private Long targetLimit;
    private Map<String, Object> additionalProperties;

    public ServiceMonitorSpecFluent() {
    }

    public ServiceMonitorSpecFluent(ServiceMonitorSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceMonitorSpec instance) {
        ServiceMonitorSpec serviceMonitorSpec = instance = instance != null ? instance : new ServiceMonitorSpec();
        if (instance != null) {
            this.withAttachMetadata(instance.getAttachMetadata());
            this.withEndpoints(instance.getEndpoints());
            this.withJobLabel(instance.getJobLabel());
            this.withKeepDroppedTargets(instance.getKeepDroppedTargets());
            this.withLabelLimit(instance.getLabelLimit());
            this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
            this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withPodTargetLabels(instance.getPodTargetLabels());
            this.withSampleLimit(instance.getSampleLimit());
            this.withSelector(instance.getSelector());
            this.withTargetLabels(instance.getTargetLabels());
            this.withTargetLimit(instance.getTargetLimit());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AttachMetadata buildAttachMetadata() {
        return this.attachMetadata != null ? this.attachMetadata.build() : null;
    }

    public A withAttachMetadata(AttachMetadata attachMetadata) {
        this._visitables.remove((Object)"attachMetadata");
        if (attachMetadata != null) {
            this.attachMetadata = new AttachMetadataBuilder(attachMetadata);
            this._visitables.get((Object)"attachMetadata").add(this.attachMetadata);
        } else {
            this.attachMetadata = null;
            this._visitables.get((Object)"attachMetadata").remove((Object)this.attachMetadata);
        }
        return (A)((Object)this);
    }

    public boolean hasAttachMetadata() {
        return this.attachMetadata != null;
    }

    public A withNewAttachMetadata(Boolean node) {
        return this.withAttachMetadata(new AttachMetadata(node));
    }

    public AttachMetadataNested<A> withNewAttachMetadata() {
        return new AttachMetadataNested(null);
    }

    public AttachMetadataNested<A> withNewAttachMetadataLike(AttachMetadata item) {
        return new AttachMetadataNested(item);
    }

    public AttachMetadataNested<A> editAttachMetadata() {
        return this.withNewAttachMetadataLike(Optional.ofNullable(this.buildAttachMetadata()).orElse(null));
    }

    public AttachMetadataNested<A> editOrNewAttachMetadata() {
        return this.withNewAttachMetadataLike(Optional.ofNullable(this.buildAttachMetadata()).orElse(new AttachMetadataBuilder().build()));
    }

    public AttachMetadataNested<A> editOrNewAttachMetadataLike(AttachMetadata item) {
        return this.withNewAttachMetadataLike(Optional.ofNullable(this.buildAttachMetadata()).orElse(item));
    }

    public A addToEndpoints(int index, Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        EndpointBuilder builder = new EndpointBuilder(item);
        if (index < 0 || index >= this.endpoints.size()) {
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(builder);
        } else {
            this._visitables.get((Object)"endpoints").add(index, builder);
            this.endpoints.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEndpoints(int index, Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        EndpointBuilder builder = new EndpointBuilder(item);
        if (index < 0 || index >= this.endpoints.size()) {
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(builder);
        } else {
            this._visitables.get((Object)"endpoints").set(index, builder);
            this.endpoints.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEndpoints(Endpoint ... items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEndpoints(Collection<Endpoint> items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEndpoints(Endpoint ... items) {
        if (this.endpoints == null) {
            return (A)((Object)this);
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get((Object)"endpoints").remove((Object)builder);
            this.endpoints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEndpoints(Collection<Endpoint> items) {
        if (this.endpoints == null) {
            return (A)((Object)this);
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get((Object)"endpoints").remove((Object)builder);
            this.endpoints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEndpoints(Predicate<EndpointBuilder> predicate) {
        if (this.endpoints == null) {
            return (A)((Object)this);
        }
        Iterator<EndpointBuilder> each = this.endpoints.iterator();
        List visitables = this._visitables.get((Object)"endpoints");
        while (each.hasNext()) {
            EndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Endpoint> buildEndpoints() {
        return this.endpoints != null ? ServiceMonitorSpecFluent.build(this.endpoints) : null;
    }

    public Endpoint buildEndpoint(int index) {
        return this.endpoints.get(index).build();
    }

    public Endpoint buildFirstEndpoint() {
        return this.endpoints.get(0).build();
    }

    public Endpoint buildLastEndpoint() {
        return this.endpoints.get(this.endpoints.size() - 1).build();
    }

    public Endpoint buildMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item : this.endpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item : this.endpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEndpoints(List<Endpoint> endpoints) {
        if (this.endpoints != null) {
            this._visitables.get((Object)"endpoints").clear();
        }
        if (endpoints != null) {
            this.endpoints = new ArrayList();
            for (Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        } else {
            this.endpoints = null;
        }
        return (A)((Object)this);
    }

    public A withEndpoints(Endpoint ... endpoints) {
        if (this.endpoints != null) {
            this.endpoints.clear();
            this._visitables.remove((Object)"endpoints");
        }
        if (endpoints != null) {
            for (Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEndpoints() {
        return this.endpoints != null && !this.endpoints.isEmpty();
    }

    public EndpointsNested<A> addNewEndpoint() {
        return new EndpointsNested(-1, null);
    }

    public EndpointsNested<A> addNewEndpointLike(Endpoint item) {
        return new EndpointsNested(-1, item);
    }

    public EndpointsNested<A> setNewEndpointLike(int index, Endpoint item) {
        return new EndpointsNested(index, item);
    }

    public EndpointsNested<A> editEndpoint(int index) {
        if (this.endpoints.size() <= index) {
            throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    public EndpointsNested<A> editFirstEndpoint() {
        if (this.endpoints.size() == 0) {
            throw new RuntimeException("Can't edit first endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(0, this.buildEndpoint(0));
    }

    public EndpointsNested<A> editLastEndpoint() {
        int index = this.endpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    public EndpointsNested<A> editMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            if (!predicate.test(this.endpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching endpoints. No match found.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    public String getJobLabel() {
        return this.jobLabel;
    }

    public A withJobLabel(String jobLabel) {
        this.jobLabel = jobLabel;
        return (A)((Object)this);
    }

    public boolean hasJobLabel() {
        return this.jobLabel != null;
    }

    public Long getKeepDroppedTargets() {
        return this.keepDroppedTargets;
    }

    public A withKeepDroppedTargets(Long keepDroppedTargets) {
        this.keepDroppedTargets = keepDroppedTargets;
        return (A)((Object)this);
    }

    public boolean hasKeepDroppedTargets() {
        return this.keepDroppedTargets != null;
    }

    public Long getLabelLimit() {
        return this.labelLimit;
    }

    public A withLabelLimit(Long labelLimit) {
        this.labelLimit = labelLimit;
        return (A)((Object)this);
    }

    public boolean hasLabelLimit() {
        return this.labelLimit != null;
    }

    public Long getLabelNameLengthLimit() {
        return this.labelNameLengthLimit;
    }

    public A withLabelNameLengthLimit(Long labelNameLengthLimit) {
        this.labelNameLengthLimit = labelNameLengthLimit;
        return (A)((Object)this);
    }

    public boolean hasLabelNameLengthLimit() {
        return this.labelNameLengthLimit != null;
    }

    public Long getLabelValueLengthLimit() {
        return this.labelValueLengthLimit;
    }

    public A withLabelValueLengthLimit(Long labelValueLengthLimit) {
        this.labelValueLengthLimit = labelValueLengthLimit;
        return (A)((Object)this);
    }

    public boolean hasLabelValueLengthLimit() {
        return this.labelValueLengthLimit != null;
    }

    public NamespaceSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    public A withNamespaceSelector(NamespaceSelector namespaceSelector) {
        this._visitables.remove((Object)"namespaceSelector");
        if (namespaceSelector != null) {
            this.namespaceSelector = new NamespaceSelectorBuilder(namespaceSelector);
            this._visitables.get((Object)"namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get((Object)"namespaceSelector").remove((Object)this.namespaceSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNested(null);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item) {
        return new NamespaceSelectorNested(item);
    }

    public NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(null));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(new NamespaceSelectorBuilder().build()));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item) {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(item));
    }

    public A addToPodTargetLabels(int index, String item) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        this.podTargetLabels.add(index, item);
        return (A)((Object)this);
    }

    public A setToPodTargetLabels(int index, String item) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        this.podTargetLabels.set(index, item);
        return (A)((Object)this);
    }

    public A addToPodTargetLabels(String ... items) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.podTargetLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPodTargetLabels(Collection<String> items) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.podTargetLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPodTargetLabels(String ... items) {
        if (this.podTargetLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.podTargetLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPodTargetLabels(Collection<String> items) {
        if (this.podTargetLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.podTargetLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPodTargetLabels() {
        return this.podTargetLabels;
    }

    public String getPodTargetLabel(int index) {
        return this.podTargetLabels.get(index);
    }

    public String getFirstPodTargetLabel() {
        return this.podTargetLabels.get(0);
    }

    public String getLastPodTargetLabel() {
        return this.podTargetLabels.get(this.podTargetLabels.size() - 1);
    }

    public String getMatchingPodTargetLabel(Predicate<String> predicate) {
        for (String item : this.podTargetLabels) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPodTargetLabel(Predicate<String> predicate) {
        for (String item : this.podTargetLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPodTargetLabels(List<String> podTargetLabels) {
        if (podTargetLabels != null) {
            this.podTargetLabels = new ArrayList<String>();
            for (String item : podTargetLabels) {
                this.addToPodTargetLabels(item);
            }
        } else {
            this.podTargetLabels = null;
        }
        return (A)((Object)this);
    }

    public A withPodTargetLabels(String ... podTargetLabels) {
        if (this.podTargetLabels != null) {
            this.podTargetLabels.clear();
            this._visitables.remove((Object)"podTargetLabels");
        }
        if (podTargetLabels != null) {
            for (String item : podTargetLabels) {
                this.addToPodTargetLabels(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPodTargetLabels() {
        return this.podTargetLabels != null && !this.podTargetLabels.isEmpty();
    }

    public Long getSampleLimit() {
        return this.sampleLimit;
    }

    public A withSampleLimit(Long sampleLimit) {
        this.sampleLimit = sampleLimit;
        return (A)((Object)this);
    }

    public boolean hasSampleLimit() {
        return this.sampleLimit != null;
    }

    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(LabelSelector selector) {
        this._visitables.remove((Object)"selector");
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove(this.selector);
        }
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public A addToTargetLabels(int index, String item) {
        if (this.targetLabels == null) {
            this.targetLabels = new ArrayList<String>();
        }
        this.targetLabels.add(index, item);
        return (A)((Object)this);
    }

    public A setToTargetLabels(int index, String item) {
        if (this.targetLabels == null) {
            this.targetLabels = new ArrayList<String>();
        }
        this.targetLabels.set(index, item);
        return (A)((Object)this);
    }

    public A addToTargetLabels(String ... items) {
        if (this.targetLabels == null) {
            this.targetLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTargetLabels(Collection<String> items) {
        if (this.targetLabels == null) {
            this.targetLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTargetLabels(String ... items) {
        if (this.targetLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.targetLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTargetLabels(Collection<String> items) {
        if (this.targetLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.targetLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTargetLabels() {
        return this.targetLabels;
    }

    public String getTargetLabel(int index) {
        return this.targetLabels.get(index);
    }

    public String getFirstTargetLabel() {
        return this.targetLabels.get(0);
    }

    public String getLastTargetLabel() {
        return this.targetLabels.get(this.targetLabels.size() - 1);
    }

    public String getMatchingTargetLabel(Predicate<String> predicate) {
        for (String item : this.targetLabels) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTargetLabel(Predicate<String> predicate) {
        for (String item : this.targetLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTargetLabels(List<String> targetLabels) {
        if (targetLabels != null) {
            this.targetLabels = new ArrayList<String>();
            for (String item : targetLabels) {
                this.addToTargetLabels(item);
            }
        } else {
            this.targetLabels = null;
        }
        return (A)((Object)this);
    }

    public A withTargetLabels(String ... targetLabels) {
        if (this.targetLabels != null) {
            this.targetLabels.clear();
            this._visitables.remove((Object)"targetLabels");
        }
        if (targetLabels != null) {
            for (String item : targetLabels) {
                this.addToTargetLabels(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTargetLabels() {
        return this.targetLabels != null && !this.targetLabels.isEmpty();
    }

    public Long getTargetLimit() {
        return this.targetLimit;
    }

    public A withTargetLimit(Long targetLimit) {
        this.targetLimit = targetLimit;
        return (A)((Object)this);
    }

    public boolean hasTargetLimit() {
        return this.targetLimit != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceMonitorSpecFluent that = (ServiceMonitorSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.attachMetadata, (Object)that.attachMetadata)) {
            return false;
        }
        if (!Objects.equals(this.endpoints, that.endpoints)) {
            return false;
        }
        if (!Objects.equals(this.jobLabel, that.jobLabel)) {
            return false;
        }
        if (!Objects.equals(this.keepDroppedTargets, that.keepDroppedTargets)) {
            return false;
        }
        if (!Objects.equals(this.labelLimit, that.labelLimit)) {
            return false;
        }
        if (!Objects.equals(this.labelNameLengthLimit, that.labelNameLengthLimit)) {
            return false;
        }
        if (!Objects.equals(this.labelValueLengthLimit, that.labelValueLengthLimit)) {
            return false;
        }
        if (!Objects.equals((Object)this.namespaceSelector, (Object)that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.podTargetLabels, that.podTargetLabels)) {
            return false;
        }
        if (!Objects.equals(this.sampleLimit, that.sampleLimit)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.targetLabels, that.targetLabels)) {
            return false;
        }
        if (!Objects.equals(this.targetLimit, that.targetLimit)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attachMetadata, this.endpoints, this.jobLabel, this.keepDroppedTargets, this.labelLimit, this.labelNameLengthLimit, this.labelValueLengthLimit, this.namespaceSelector, this.podTargetLabels, this.sampleLimit, this.selector, this.targetLabels, this.targetLimit, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachMetadata != null) {
            sb.append("attachMetadata:");
            sb.append((Object)((Object)this.attachMetadata) + ",");
        }
        if (this.endpoints != null && !this.endpoints.isEmpty()) {
            sb.append("endpoints:");
            sb.append(this.endpoints + ",");
        }
        if (this.jobLabel != null) {
            sb.append("jobLabel:");
            sb.append(this.jobLabel + ",");
        }
        if (this.keepDroppedTargets != null) {
            sb.append("keepDroppedTargets:");
            sb.append(this.keepDroppedTargets + ",");
        }
        if (this.labelLimit != null) {
            sb.append("labelLimit:");
            sb.append(this.labelLimit + ",");
        }
        if (this.labelNameLengthLimit != null) {
            sb.append("labelNameLengthLimit:");
            sb.append(this.labelNameLengthLimit + ",");
        }
        if (this.labelValueLengthLimit != null) {
            sb.append("labelValueLengthLimit:");
            sb.append(this.labelValueLengthLimit + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append((Object)((Object)this.namespaceSelector) + ",");
        }
        if (this.podTargetLabels != null && !this.podTargetLabels.isEmpty()) {
            sb.append("podTargetLabels:");
            sb.append(this.podTargetLabels + ",");
        }
        if (this.sampleLimit != null) {
            sb.append("sampleLimit:");
            sb.append(this.sampleLimit + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.targetLabels != null && !this.targetLabels.isEmpty()) {
            sb.append("targetLabels:");
            sb.append(this.targetLabels + ",");
        }
        if (this.targetLimit != null) {
            sb.append("targetLimit:");
            sb.append(this.targetLimit + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SelectorNested<N>
    extends LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)ServiceMonitorSpecFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }

    public class NamespaceSelectorNested<N>
    extends NamespaceSelectorFluent<NamespaceSelectorNested<N>>
    implements Nested<N> {
        NamespaceSelectorBuilder builder;

        NamespaceSelectorNested(NamespaceSelector item) {
            this.builder = new NamespaceSelectorBuilder(this, item);
        }

        public N and() {
            return (N)ServiceMonitorSpecFluent.this.withNamespaceSelector(this.builder.build());
        }

        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class EndpointsNested<N>
    extends EndpointFluent<EndpointsNested<N>>
    implements Nested<N> {
        EndpointBuilder builder;
        int index;

        EndpointsNested(int index, Endpoint item) {
            this.index = index;
            this.builder = new EndpointBuilder(this, item);
        }

        public N and() {
            return (N)ServiceMonitorSpecFluent.this.setToEndpoints(this.index, this.builder.build());
        }

        public N endEndpoint() {
            return this.and();
        }
    }

    public class AttachMetadataNested<N>
    extends AttachMetadataFluent<AttachMetadataNested<N>>
    implements Nested<N> {
        AttachMetadataBuilder builder;

        AttachMetadataNested(AttachMetadata item) {
            this.builder = new AttachMetadataBuilder(this, item);
        }

        public N and() {
            return (N)ServiceMonitorSpecFluent.this.withAttachMetadata(this.builder.build());
        }

        public N endAttachMetadata() {
            return this.and();
        }
    }
}

