/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.monitoring.v1.OTLPConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OTLPConfigFluent<A extends OTLPConfigFluent<A>>
extends BaseFluent<A> {
    private List<String> promoteResourceAttributes = new ArrayList<String>();
    private String translationStrategy;
    private Map<String, Object> additionalProperties;

    public OTLPConfigFluent() {
    }

    public OTLPConfigFluent(OTLPConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OTLPConfig instance) {
        OTLPConfig oTLPConfig = instance = instance != null ? instance : new OTLPConfig();
        if (instance != null) {
            this.withPromoteResourceAttributes(instance.getPromoteResourceAttributes());
            this.withTranslationStrategy(instance.getTranslationStrategy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToPromoteResourceAttributes(int index, String item) {
        if (this.promoteResourceAttributes == null) {
            this.promoteResourceAttributes = new ArrayList<String>();
        }
        this.promoteResourceAttributes.add(index, item);
        return (A)((Object)this);
    }

    public A setToPromoteResourceAttributes(int index, String item) {
        if (this.promoteResourceAttributes == null) {
            this.promoteResourceAttributes = new ArrayList<String>();
        }
        this.promoteResourceAttributes.set(index, item);
        return (A)((Object)this);
    }

    public A addToPromoteResourceAttributes(String ... items) {
        if (this.promoteResourceAttributes == null) {
            this.promoteResourceAttributes = new ArrayList<String>();
        }
        for (String item : items) {
            this.promoteResourceAttributes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPromoteResourceAttributes(Collection<String> items) {
        if (this.promoteResourceAttributes == null) {
            this.promoteResourceAttributes = new ArrayList<String>();
        }
        for (String item : items) {
            this.promoteResourceAttributes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPromoteResourceAttributes(String ... items) {
        if (this.promoteResourceAttributes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.promoteResourceAttributes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPromoteResourceAttributes(Collection<String> items) {
        if (this.promoteResourceAttributes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.promoteResourceAttributes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPromoteResourceAttributes() {
        return this.promoteResourceAttributes;
    }

    public String getPromoteResourceAttribute(int index) {
        return this.promoteResourceAttributes.get(index);
    }

    public String getFirstPromoteResourceAttribute() {
        return this.promoteResourceAttributes.get(0);
    }

    public String getLastPromoteResourceAttribute() {
        return this.promoteResourceAttributes.get(this.promoteResourceAttributes.size() - 1);
    }

    public String getMatchingPromoteResourceAttribute(Predicate<String> predicate) {
        for (String item : this.promoteResourceAttributes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPromoteResourceAttribute(Predicate<String> predicate) {
        for (String item : this.promoteResourceAttributes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPromoteResourceAttributes(List<String> promoteResourceAttributes) {
        if (promoteResourceAttributes != null) {
            this.promoteResourceAttributes = new ArrayList<String>();
            for (String item : promoteResourceAttributes) {
                this.addToPromoteResourceAttributes(item);
            }
        } else {
            this.promoteResourceAttributes = null;
        }
        return (A)((Object)this);
    }

    public A withPromoteResourceAttributes(String ... promoteResourceAttributes) {
        if (this.promoteResourceAttributes != null) {
            this.promoteResourceAttributes.clear();
            this._visitables.remove((Object)"promoteResourceAttributes");
        }
        if (promoteResourceAttributes != null) {
            for (String item : promoteResourceAttributes) {
                this.addToPromoteResourceAttributes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPromoteResourceAttributes() {
        return this.promoteResourceAttributes != null && !this.promoteResourceAttributes.isEmpty();
    }

    public String getTranslationStrategy() {
        return this.translationStrategy;
    }

    public A withTranslationStrategy(String translationStrategy) {
        this.translationStrategy = translationStrategy;
        return (A)((Object)this);
    }

    public boolean hasTranslationStrategy() {
        return this.translationStrategy != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OTLPConfigFluent that = (OTLPConfigFluent)((Object)o);
        if (!Objects.equals(this.promoteResourceAttributes, that.promoteResourceAttributes)) {
            return false;
        }
        if (!Objects.equals(this.translationStrategy, that.translationStrategy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.promoteResourceAttributes, this.translationStrategy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.promoteResourceAttributes != null && !this.promoteResourceAttributes.isEmpty()) {
            sb.append("promoteResourceAttributes:");
            sb.append(this.promoteResourceAttributes + ",");
        }
        if (this.translationStrategy != null) {
            sb.append("translationStrategy:");
            sb.append(this.translationStrategy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

