package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StaticIPAMConfigBuilder extends StaticIPAMConfigFluent<StaticIPAMConfigBuilder> implements VisitableBuilder<StaticIPAMConfig,StaticIPAMConfigBuilder>{
  public StaticIPAMConfigBuilder() {
    this(new StaticIPAMConfig());
  }
  
  public StaticIPAMConfigBuilder(StaticIPAMConfigFluent<?> fluent) {
    this(fluent, new StaticIPAMConfig());
  }
  
  public StaticIPAMConfigBuilder(StaticIPAMConfigFluent<?> fluent,StaticIPAMConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StaticIPAMConfigBuilder(StaticIPAMConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StaticIPAMConfigFluent<?> fluent;
  
  public StaticIPAMConfig build() {
    StaticIPAMConfig buildable = new StaticIPAMConfig(fluent.buildAddresses(),fluent.buildDns(),fluent.buildRoutes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}