package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ProjectAccessBuilder extends ProjectAccessFluent<ProjectAccessBuilder> implements VisitableBuilder<ProjectAccess,ProjectAccessBuilder>{
  public ProjectAccessBuilder() {
    this(new ProjectAccess());
  }
  
  public ProjectAccessBuilder(ProjectAccessFluent<?> fluent) {
    this(fluent, new ProjectAccess());
  }
  
  public ProjectAccessBuilder(ProjectAccessFluent<?> fluent,ProjectAccess instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ProjectAccessBuilder(ProjectAccess instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ProjectAccessFluent<?> fluent;
  
  public ProjectAccess build() {
    ProjectAccess buildable = new ProjectAccess(fluent.getAvailableClusterRoles());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}