package io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GroupResourceBuilder extends GroupResourceFluent<GroupResourceBuilder> implements VisitableBuilder<GroupResource,GroupResourceBuilder>{
  public GroupResourceBuilder() {
    this(new GroupResource());
  }
  
  public GroupResourceBuilder(GroupResourceFluent<?> fluent) {
    this(fluent, new GroupResource());
  }
  
  public GroupResourceBuilder(GroupResourceFluent<?> fluent,GroupResource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GroupResourceBuilder(GroupResource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GroupResourceFluent<?> fluent;
  
  public GroupResource build() {
    GroupResource buildable = new GroupResource(fluent.getGroup(),fluent.getResource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}