package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ProfileStatusConditionBuilder extends ProfileStatusConditionFluent<ProfileStatusConditionBuilder> implements VisitableBuilder<ProfileStatusCondition,ProfileStatusConditionBuilder>{
  public ProfileStatusConditionBuilder() {
    this(new ProfileStatusCondition());
  }
  
  public ProfileStatusConditionBuilder(ProfileStatusConditionFluent<?> fluent) {
    this(fluent, new ProfileStatusCondition());
  }
  
  public ProfileStatusConditionBuilder(ProfileStatusConditionFluent<?> fluent,ProfileStatusCondition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ProfileStatusConditionBuilder(ProfileStatusCondition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ProfileStatusConditionFluent<?> fluent;
  
  public ProfileStatusCondition build() {
    ProfileStatusCondition buildable = new ProfileStatusCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}