package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class UserRestrictionBuilder extends UserRestrictionFluent<UserRestrictionBuilder> implements VisitableBuilder<UserRestriction,UserRestrictionBuilder>{
  public UserRestrictionBuilder() {
    this(new UserRestriction());
  }
  
  public UserRestrictionBuilder(UserRestrictionFluent<?> fluent) {
    this(fluent, new UserRestriction());
  }
  
  public UserRestrictionBuilder(UserRestrictionFluent<?> fluent,UserRestriction instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public UserRestrictionBuilder(UserRestriction instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  UserRestrictionFluent<?> fluent;
  
  public UserRestriction build() {
    UserRestriction buildable = new UserRestriction(fluent.getGroups(),fluent.buildLabels(),fluent.getUsers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}