package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class JenkinsPipelineBuildStrategyBuilder extends JenkinsPipelineBuildStrategyFluent<JenkinsPipelineBuildStrategyBuilder> implements VisitableBuilder<JenkinsPipelineBuildStrategy,JenkinsPipelineBuildStrategyBuilder>{
  public JenkinsPipelineBuildStrategyBuilder() {
    this(new JenkinsPipelineBuildStrategy());
  }
  
  public JenkinsPipelineBuildStrategyBuilder(JenkinsPipelineBuildStrategyFluent<?> fluent) {
    this(fluent, new JenkinsPipelineBuildStrategy());
  }
  
  public JenkinsPipelineBuildStrategyBuilder(JenkinsPipelineBuildStrategyFluent<?> fluent,JenkinsPipelineBuildStrategy instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public JenkinsPipelineBuildStrategyBuilder(JenkinsPipelineBuildStrategy instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  JenkinsPipelineBuildStrategyFluent<?> fluent;
  
  public JenkinsPipelineBuildStrategy build() {
    JenkinsPipelineBuildStrategy buildable = new JenkinsPipelineBuildStrategy(fluent.getEnv(),fluent.getJenkinsfile(),fluent.getJenkinsfilePath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}