/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.openshift.api.model.ImageLookupPolicy;
import io.fabric8.openshift.api.model.ImageStreamSpecBuilder;
import io.fabric8.openshift.api.model.TagReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"dockerImageRepository", "lookupPolicy", "tags"})
public class ImageStreamSpec
implements Editable<ImageStreamSpecBuilder>,
KubernetesResource {
    @JsonProperty(value="dockerImageRepository")
    private String dockerImageRepository;
    @JsonProperty(value="lookupPolicy")
    private ImageLookupPolicy lookupPolicy;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<TagReference> tags = new ArrayList<TagReference>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public ImageStreamSpec() {
    }

    public ImageStreamSpec(String dockerImageRepository, ImageLookupPolicy lookupPolicy, List<TagReference> tags) {
        this.dockerImageRepository = dockerImageRepository;
        this.lookupPolicy = lookupPolicy;
        this.tags = tags;
    }

    @JsonProperty(value="dockerImageRepository")
    public String getDockerImageRepository() {
        return this.dockerImageRepository;
    }

    @JsonProperty(value="dockerImageRepository")
    public void setDockerImageRepository(String dockerImageRepository) {
        this.dockerImageRepository = dockerImageRepository;
    }

    @JsonProperty(value="lookupPolicy")
    public ImageLookupPolicy getLookupPolicy() {
        return this.lookupPolicy;
    }

    @JsonProperty(value="lookupPolicy")
    public void setLookupPolicy(ImageLookupPolicy lookupPolicy) {
        this.lookupPolicy = lookupPolicy;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<TagReference> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<TagReference> tags) {
        this.tags = tags;
    }

    @JsonIgnore
    public ImageStreamSpecBuilder edit() {
        return new ImageStreamSpecBuilder(this);
    }

    @JsonIgnore
    public ImageStreamSpecBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public String toString() {
        return "ImageStreamSpec(dockerImageRepository=" + this.getDockerImageRepository() + ", lookupPolicy=" + this.getLookupPolicy() + ", tags=" + this.getTags() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageStreamSpec)) {
            return false;
        }
        ImageStreamSpec other = (ImageStreamSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dockerImageRepository = this.getDockerImageRepository();
        String other$dockerImageRepository = other.getDockerImageRepository();
        if (this$dockerImageRepository == null ? other$dockerImageRepository != null : !this$dockerImageRepository.equals(other$dockerImageRepository)) {
            return false;
        }
        ImageLookupPolicy this$lookupPolicy = this.getLookupPolicy();
        ImageLookupPolicy other$lookupPolicy = other.getLookupPolicy();
        if (this$lookupPolicy == null ? other$lookupPolicy != null : !((Object)this$lookupPolicy).equals(other$lookupPolicy)) {
            return false;
        }
        List<TagReference> this$tags = this.getTags();
        List<TagReference> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImageStreamSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dockerImageRepository = this.getDockerImageRepository();
        result = result * 59 + ($dockerImageRepository == null ? 43 : $dockerImageRepository.hashCode());
        ImageLookupPolicy $lookupPolicy = this.getLookupPolicy();
        result = result * 59 + ($lookupPolicy == null ? 43 : ((Object)$lookupPolicy).hashCode());
        List<TagReference> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

