package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CatalogRestrictionsBuilder extends CatalogRestrictionsFluent<CatalogRestrictionsBuilder> implements VisitableBuilder<CatalogRestrictions,CatalogRestrictionsBuilder>{
  public CatalogRestrictionsBuilder() {
    this(new CatalogRestrictions());
  }
  
  public CatalogRestrictionsBuilder(CatalogRestrictionsFluent<?> fluent) {
    this(fluent, new CatalogRestrictions());
  }
  
  public CatalogRestrictionsBuilder(CatalogRestrictionsFluent<?> fluent,CatalogRestrictions instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CatalogRestrictionsBuilder(CatalogRestrictions instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CatalogRestrictionsFluent<?> fluent;
  
  public CatalogRestrictions build() {
    CatalogRestrictions buildable = new CatalogRestrictions(fluent.getServiceClass(),fluent.getServicePlan());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}