package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class LocalObjectReferenceBuilder extends LocalObjectReferenceFluent<LocalObjectReferenceBuilder> implements VisitableBuilder<LocalObjectReference,LocalObjectReferenceBuilder>{
  public LocalObjectReferenceBuilder() {
    this(new LocalObjectReference());
  }
  
  public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent) {
    this(fluent, new LocalObjectReference());
  }
  
  public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent,LocalObjectReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public LocalObjectReferenceBuilder(LocalObjectReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  LocalObjectReferenceFluent<?> fluent;
  
  public LocalObjectReference build() {
    LocalObjectReference buildable = new LocalObjectReference(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}