package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceClassListBuilder extends ServiceClassListFluent<ServiceClassListBuilder> implements VisitableBuilder<ServiceClassList,ServiceClassListBuilder>{
  public ServiceClassListBuilder() {
    this(new ServiceClassList());
  }
  
  public ServiceClassListBuilder(ServiceClassListFluent<?> fluent) {
    this(fluent, new ServiceClassList());
  }
  
  public ServiceClassListBuilder(ServiceClassListFluent<?> fluent,ServiceClassList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceClassListBuilder(ServiceClassList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceClassListFluent<?> fluent;
  
  public ServiceClassList build() {
    ServiceClassList buildable = new ServiceClassList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}