/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.tekton.pipeline.v1alpha1.ConditionCheckStatus;
import io.fabric8.tekton.pipeline.v1alpha1.ConditionCheckStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ConditionCheckStatusFluentImpl<A extends ConditionCheckStatusFluent<A>>
extends BaseFluent<A>
implements ConditionCheckStatusFluent<A> {
    private ContainerState check;
    private String completionTime;
    private List<Condition> conditions = new ArrayList<Condition>();
    private Long observedGeneration;
    private String podName;
    private String startTime;

    public ConditionCheckStatusFluentImpl() {
    }

    public ConditionCheckStatusFluentImpl(ConditionCheckStatus instance) {
        this.withCheck(instance.getCheck());
        this.withCompletionTime(instance.getCompletionTime());
        this.withConditions(instance.getConditions());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withPodName(instance.getPodName());
        this.withStartTime(instance.getStartTime());
    }

    @Override
    public ContainerState getCheck() {
        return this.check;
    }

    @Override
    public A withCheck(ContainerState check) {
        this.check = check;
        return (A)this;
    }

    @Override
    public Boolean hasCheck() {
        return this.check != null;
    }

    @Override
    public String getCompletionTime() {
        return this.completionTime;
    }

    @Override
    public A withCompletionTime(String completionTime) {
        this.completionTime = completionTime;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionTime() {
        return this.completionTime != null;
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public Condition getCondition(Integer index) {
        return this.conditions.get(index);
    }

    @Override
    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    @Override
    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    @Override
    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public String getPodName() {
        return this.podName;
    }

    @Override
    public A withPodName(String podName) {
        this.podName = podName;
        return (A)this;
    }

    @Override
    public Boolean hasPodName() {
        return this.podName != null;
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    @Override
    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionCheckStatusFluentImpl that = (ConditionCheckStatusFluentImpl)o;
        if (this.check != null ? !this.check.equals((Object)that.check) : that.check != null) {
            return false;
        }
        if (this.completionTime != null ? !this.completionTime.equals(that.completionTime) : that.completionTime != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        if (this.podName != null ? !this.podName.equals(that.podName) : that.podName != null) {
            return false;
        }
        return !(this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null);
    }

    public int hashCode() {
        return Objects.hash(this.check, this.completionTime, this.conditions, this.observedGeneration, this.podName, this.startTime, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.check != null) {
            sb.append("check:");
            sb.append(this.check + ",");
        }
        if (this.completionTime != null) {
            sb.append("completionTime:");
            sb.append(this.completionTime + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.podName != null) {
            sb.append("podName:");
            sb.append(this.podName + ",");
        }
        if (this.startTime != null) {
            sb.append("startTime:");
            sb.append(this.startTime);
        }
        sb.append("}");
        return sb.toString();
    }
}

