/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.Inputs;
import io.fabric8.tekton.pipeline.v1alpha1.InputsBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.InputsFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.Outputs;
import io.fabric8.tekton.pipeline.v1alpha1.OutputsBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.OutputsFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.TaskResult;
import io.fabric8.tekton.pipeline.v1alpha1.TaskResultBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.TaskResultFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.TaskSpec;
import io.fabric8.tekton.pipeline.v1alpha1.TaskSpecFluent;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.Step;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.StepBuilder;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.StepFluentImpl;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.WorkspaceDeclaration;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.WorkspaceDeclarationBuilder;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.WorkspaceDeclarationFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class TaskSpecFluentImpl<A extends TaskSpecFluent<A>>
extends BaseFluent<A>
implements TaskSpecFluent<A> {
    private InputsBuilder inputs;
    private OutputsBuilder outputs;
    private ArrayList<TaskResultBuilder> results = new ArrayList();
    private ArrayList<ContainerBuilder> sidecars = new ArrayList();
    private ContainerBuilder stepTemplate;
    private ArrayList<StepBuilder> steps = new ArrayList();
    private ArrayList<VolumeBuilder> volumes = new ArrayList();
    private ArrayList<WorkspaceDeclarationBuilder> workspaces = new ArrayList();

    public TaskSpecFluentImpl() {
    }

    public TaskSpecFluentImpl(TaskSpec instance) {
        this.withInputs(instance.getInputs());
        this.withOutputs(instance.getOutputs());
        this.withResults(instance.getResults());
        this.withSidecars(instance.getSidecars());
        this.withStepTemplate(instance.getStepTemplate());
        this.withSteps(instance.getSteps());
        this.withVolumes(instance.getVolumes());
        this.withWorkspaces(instance.getWorkspaces());
    }

    @Override
    @Deprecated
    public Inputs getInputs() {
        return this.inputs != null ? this.inputs.build() : null;
    }

    @Override
    public Inputs buildInputs() {
        return this.inputs != null ? this.inputs.build() : null;
    }

    @Override
    public A withInputs(Inputs inputs) {
        this._visitables.get((Object)"inputs").remove(this.inputs);
        if (inputs != null) {
            this.inputs = new InputsBuilder(inputs);
            this._visitables.get((Object)"inputs").add(this.inputs);
        } else {
            this.inputs = null;
            this._visitables.get((Object)"inputs").remove(this.inputs);
        }
        return (A)this;
    }

    @Override
    public Boolean hasInputs() {
        return this.inputs != null;
    }

    @Override
    public TaskSpecFluent.InputsNested<A> withNewInputs() {
        return new InputsNestedImpl();
    }

    @Override
    public TaskSpecFluent.InputsNested<A> withNewInputsLike(Inputs item) {
        return new InputsNestedImpl(item);
    }

    @Override
    public TaskSpecFluent.InputsNested<A> editInputs() {
        return this.withNewInputsLike(this.getInputs());
    }

    @Override
    public TaskSpecFluent.InputsNested<A> editOrNewInputs() {
        return this.withNewInputsLike(this.getInputs() != null ? this.getInputs() : new InputsBuilder().build());
    }

    @Override
    public TaskSpecFluent.InputsNested<A> editOrNewInputsLike(Inputs item) {
        return this.withNewInputsLike(this.getInputs() != null ? this.getInputs() : item);
    }

    @Override
    @Deprecated
    public Outputs getOutputs() {
        return this.outputs != null ? this.outputs.build() : null;
    }

    @Override
    public Outputs buildOutputs() {
        return this.outputs != null ? this.outputs.build() : null;
    }

    @Override
    public A withOutputs(Outputs outputs) {
        this._visitables.get((Object)"outputs").remove(this.outputs);
        if (outputs != null) {
            this.outputs = new OutputsBuilder(outputs);
            this._visitables.get((Object)"outputs").add(this.outputs);
        } else {
            this.outputs = null;
            this._visitables.get((Object)"outputs").remove(this.outputs);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOutputs() {
        return this.outputs != null;
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> withNewOutputs() {
        return new OutputsNestedImpl();
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> withNewOutputsLike(Outputs item) {
        return new OutputsNestedImpl(item);
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> editOutputs() {
        return this.withNewOutputsLike(this.getOutputs());
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> editOrNewOutputs() {
        return this.withNewOutputsLike(this.getOutputs() != null ? this.getOutputs() : new OutputsBuilder().build());
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> editOrNewOutputsLike(Outputs item) {
        return this.withNewOutputsLike(this.getOutputs() != null ? this.getOutputs() : item);
    }

    @Override
    public A addToResults(Integer index, TaskResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        TaskResultBuilder builder = new TaskResultBuilder(item);
        this._visitables.get((Object)"results").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"results").size(), builder);
        this.results.add(index >= 0 ? index.intValue() : this.results.size(), builder);
        return (A)this;
    }

    @Override
    public A setToResults(Integer index, TaskResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        TaskResultBuilder builder = new TaskResultBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"results").size()) {
            this._visitables.get((Object)"results").add(builder);
        } else {
            this._visitables.get((Object)"results").set(index, builder);
        }
        if (index < 0 || index >= this.results.size()) {
            this.results.add(builder);
        } else {
            this.results.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResults(TaskResult ... items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (TaskResult item : items) {
            TaskResultBuilder builder = new TaskResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResults(Collection<TaskResult> items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (TaskResult item : items) {
            TaskResultBuilder builder = new TaskResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResults(TaskResult ... items) {
        for (TaskResult item : items) {
            TaskResultBuilder builder = new TaskResultBuilder(item);
            this._visitables.get((Object)"results").remove(builder);
            if (this.results == null) continue;
            this.results.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResults(Collection<TaskResult> items) {
        for (TaskResult item : items) {
            TaskResultBuilder builder = new TaskResultBuilder(item);
            this._visitables.get((Object)"results").remove(builder);
            if (this.results == null) continue;
            this.results.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromResults(Predicate<TaskResultBuilder> predicate) {
        if (this.results == null) {
            return (A)this;
        }
        Iterator<TaskResultBuilder> each = this.results.iterator();
        List visitables = this._visitables.get((Object)"results");
        while (each.hasNext()) {
            TaskResultBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TaskResult> getResults() {
        return this.results != null ? TaskSpecFluentImpl.build(this.results) : null;
    }

    @Override
    public List<TaskResult> buildResults() {
        return this.results != null ? TaskSpecFluentImpl.build(this.results) : null;
    }

    @Override
    public TaskResult buildResult(Integer index) {
        return this.results.get(index).build();
    }

    @Override
    public TaskResult buildFirstResult() {
        return this.results.get(0).build();
    }

    @Override
    public TaskResult buildLastResult() {
        return this.results.get(this.results.size() - 1).build();
    }

    @Override
    public TaskResult buildMatchingResult(Predicate<TaskResultBuilder> predicate) {
        for (TaskResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResult(Predicate<TaskResultBuilder> predicate) {
        for (TaskResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResults(List<TaskResult> results) {
        if (this.results != null) {
            this._visitables.get((Object)"results").removeAll(this.results);
        }
        if (results != null) {
            this.results = new ArrayList();
            for (TaskResult item : results) {
                this.addToResults(item);
            }
        } else {
            this.results = null;
        }
        return (A)this;
    }

    @Override
    public A withResults(TaskResult ... results) {
        if (this.results != null) {
            this.results.clear();
        }
        if (results != null) {
            for (TaskResult item : results) {
                this.addToResults(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResults() {
        return this.results != null && !this.results.isEmpty();
    }

    @Override
    public A addNewResult(String description, String name) {
        return this.addToResults(new TaskResult(description, name));
    }

    @Override
    public TaskSpecFluent.ResultsNested<A> addNewResult() {
        return new ResultsNestedImpl();
    }

    @Override
    public TaskSpecFluent.ResultsNested<A> addNewResultLike(TaskResult item) {
        return new ResultsNestedImpl(-1, item);
    }

    @Override
    public TaskSpecFluent.ResultsNested<A> setNewResultLike(Integer index, TaskResult item) {
        return new ResultsNestedImpl(index, item);
    }

    @Override
    public TaskSpecFluent.ResultsNested<A> editResult(Integer index) {
        if (this.results.size() <= index) {
            throw new RuntimeException("Can't edit results. Index exceeds size.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    @Override
    public TaskSpecFluent.ResultsNested<A> editFirstResult() {
        if (this.results.size() == 0) {
            throw new RuntimeException("Can't edit first results. The list is empty.");
        }
        return this.setNewResultLike(0, this.buildResult(0));
    }

    @Override
    public TaskSpecFluent.ResultsNested<A> editLastResult() {
        int index = this.results.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last results. The list is empty.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    @Override
    public TaskSpecFluent.ResultsNested<A> editMatchingResult(Predicate<TaskResultBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.results.size(); ++i) {
            if (!predicate.test(this.results.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching results. No match found.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    @Override
    public A addToSidecars(Integer index, Container item) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get((Object)"sidecars").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"sidecars").size(), builder);
        this.sidecars.add(index >= 0 ? index.intValue() : this.sidecars.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSidecars(Integer index, Container item) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"sidecars").size()) {
            this._visitables.get((Object)"sidecars").add(builder);
        } else {
            this._visitables.get((Object)"sidecars").set(index, builder);
        }
        if (index < 0 || index >= this.sidecars.size()) {
            this.sidecars.add(builder);
        } else {
            this.sidecars.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSidecars(Container ... items) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSidecars(Collection<Container> items) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSidecars(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"sidecars").remove(builder);
            if (this.sidecars == null) continue;
            this.sidecars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSidecars(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"sidecars").remove(builder);
            if (this.sidecars == null) continue;
            this.sidecars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSidecars(Predicate<ContainerBuilder> predicate) {
        if (this.sidecars == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.sidecars.iterator();
        List visitables = this._visitables.get((Object)"sidecars");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Container> getSidecars() {
        return this.sidecars != null ? TaskSpecFluentImpl.build(this.sidecars) : null;
    }

    @Override
    public List<Container> buildSidecars() {
        return this.sidecars != null ? TaskSpecFluentImpl.build(this.sidecars) : null;
    }

    @Override
    public Container buildSidecar(Integer index) {
        return this.sidecars.get(index).build();
    }

    @Override
    public Container buildFirstSidecar() {
        return this.sidecars.get(0).build();
    }

    @Override
    public Container buildLastSidecar() {
        return this.sidecars.get(this.sidecars.size() - 1).build();
    }

    @Override
    public Container buildMatchingSidecar(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.sidecars) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSidecar(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.sidecars) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSidecars(List<Container> sidecars) {
        if (this.sidecars != null) {
            this._visitables.get((Object)"sidecars").removeAll(this.sidecars);
        }
        if (sidecars != null) {
            this.sidecars = new ArrayList();
            for (Container item : sidecars) {
                this.addToSidecars(item);
            }
        } else {
            this.sidecars = null;
        }
        return (A)this;
    }

    @Override
    public A withSidecars(Container ... sidecars) {
        if (this.sidecars != null) {
            this.sidecars.clear();
        }
        if (sidecars != null) {
            for (Container item : sidecars) {
                this.addToSidecars(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSidecars() {
        return this.sidecars != null && !this.sidecars.isEmpty();
    }

    @Override
    public TaskSpecFluent.SidecarsNested<A> addNewSidecar() {
        return new SidecarsNestedImpl();
    }

    @Override
    public TaskSpecFluent.SidecarsNested<A> addNewSidecarLike(Container item) {
        return new SidecarsNestedImpl(-1, item);
    }

    @Override
    public TaskSpecFluent.SidecarsNested<A> setNewSidecarLike(Integer index, Container item) {
        return new SidecarsNestedImpl(index, item);
    }

    @Override
    public TaskSpecFluent.SidecarsNested<A> editSidecar(Integer index) {
        if (this.sidecars.size() <= index) {
            throw new RuntimeException("Can't edit sidecars. Index exceeds size.");
        }
        return this.setNewSidecarLike(index, this.buildSidecar(index));
    }

    @Override
    public TaskSpecFluent.SidecarsNested<A> editFirstSidecar() {
        if (this.sidecars.size() == 0) {
            throw new RuntimeException("Can't edit first sidecars. The list is empty.");
        }
        return this.setNewSidecarLike(0, this.buildSidecar(0));
    }

    @Override
    public TaskSpecFluent.SidecarsNested<A> editLastSidecar() {
        int index = this.sidecars.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sidecars. The list is empty.");
        }
        return this.setNewSidecarLike(index, this.buildSidecar(index));
    }

    @Override
    public TaskSpecFluent.SidecarsNested<A> editMatchingSidecar(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sidecars.size(); ++i) {
            if (!predicate.test(this.sidecars.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sidecars. No match found.");
        }
        return this.setNewSidecarLike(index, this.buildSidecar(index));
    }

    @Override
    @Deprecated
    public Container getStepTemplate() {
        return this.stepTemplate != null ? this.stepTemplate.build() : null;
    }

    @Override
    public Container buildStepTemplate() {
        return this.stepTemplate != null ? this.stepTemplate.build() : null;
    }

    @Override
    public A withStepTemplate(Container stepTemplate) {
        this._visitables.get((Object)"stepTemplate").remove(this.stepTemplate);
        if (stepTemplate != null) {
            this.stepTemplate = new ContainerBuilder(stepTemplate);
            this._visitables.get((Object)"stepTemplate").add(this.stepTemplate);
        } else {
            this.stepTemplate = null;
            this._visitables.get((Object)"stepTemplate").remove(this.stepTemplate);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStepTemplate() {
        return this.stepTemplate != null;
    }

    @Override
    public TaskSpecFluent.StepTemplateNested<A> withNewStepTemplate() {
        return new StepTemplateNestedImpl();
    }

    @Override
    public TaskSpecFluent.StepTemplateNested<A> withNewStepTemplateLike(Container item) {
        return new StepTemplateNestedImpl(item);
    }

    @Override
    public TaskSpecFluent.StepTemplateNested<A> editStepTemplate() {
        return this.withNewStepTemplateLike(this.getStepTemplate());
    }

    @Override
    public TaskSpecFluent.StepTemplateNested<A> editOrNewStepTemplate() {
        return this.withNewStepTemplateLike(this.getStepTemplate() != null ? this.getStepTemplate() : new ContainerBuilder().build());
    }

    @Override
    public TaskSpecFluent.StepTemplateNested<A> editOrNewStepTemplateLike(Container item) {
        return this.withNewStepTemplateLike(this.getStepTemplate() != null ? this.getStepTemplate() : item);
    }

    @Override
    public A addToSteps(Integer index, Step item) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        StepBuilder builder = new StepBuilder(item);
        this._visitables.get((Object)"steps").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"steps").size(), builder);
        this.steps.add(index >= 0 ? index.intValue() : this.steps.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSteps(Integer index, Step item) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        StepBuilder builder = new StepBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"steps").size()) {
            this._visitables.get((Object)"steps").add(builder);
        } else {
            this._visitables.get((Object)"steps").set(index, builder);
        }
        if (index < 0 || index >= this.steps.size()) {
            this.steps.add(builder);
        } else {
            this.steps.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSteps(Step ... items) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        for (Step item : items) {
            StepBuilder builder = new StepBuilder(item);
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSteps(Collection<Step> items) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        for (Step item : items) {
            StepBuilder builder = new StepBuilder(item);
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSteps(Step ... items) {
        for (Step item : items) {
            StepBuilder builder = new StepBuilder(item);
            this._visitables.get((Object)"steps").remove(builder);
            if (this.steps == null) continue;
            this.steps.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSteps(Collection<Step> items) {
        for (Step item : items) {
            StepBuilder builder = new StepBuilder(item);
            this._visitables.get((Object)"steps").remove(builder);
            if (this.steps == null) continue;
            this.steps.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSteps(Predicate<StepBuilder> predicate) {
        if (this.steps == null) {
            return (A)this;
        }
        Iterator<StepBuilder> each = this.steps.iterator();
        List visitables = this._visitables.get((Object)"steps");
        while (each.hasNext()) {
            StepBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Step> getSteps() {
        return this.steps != null ? TaskSpecFluentImpl.build(this.steps) : null;
    }

    @Override
    public List<Step> buildSteps() {
        return this.steps != null ? TaskSpecFluentImpl.build(this.steps) : null;
    }

    @Override
    public Step buildStep(Integer index) {
        return this.steps.get(index).build();
    }

    @Override
    public Step buildFirstStep() {
        return this.steps.get(0).build();
    }

    @Override
    public Step buildLastStep() {
        return this.steps.get(this.steps.size() - 1).build();
    }

    @Override
    public Step buildMatchingStep(Predicate<StepBuilder> predicate) {
        for (StepBuilder item : this.steps) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingStep(Predicate<StepBuilder> predicate) {
        for (StepBuilder item : this.steps) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSteps(List<Step> steps) {
        if (this.steps != null) {
            this._visitables.get((Object)"steps").removeAll(this.steps);
        }
        if (steps != null) {
            this.steps = new ArrayList();
            for (Step item : steps) {
                this.addToSteps(item);
            }
        } else {
            this.steps = null;
        }
        return (A)this;
    }

    @Override
    public A withSteps(Step ... steps) {
        if (this.steps != null) {
            this.steps.clear();
        }
        if (steps != null) {
            for (Step item : steps) {
                this.addToSteps(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSteps() {
        return this.steps != null && !this.steps.isEmpty();
    }

    @Override
    public TaskSpecFluent.StepsNested<A> addNewStep() {
        return new StepsNestedImpl();
    }

    @Override
    public TaskSpecFluent.StepsNested<A> addNewStepLike(Step item) {
        return new StepsNestedImpl(-1, item);
    }

    @Override
    public TaskSpecFluent.StepsNested<A> setNewStepLike(Integer index, Step item) {
        return new StepsNestedImpl(index, item);
    }

    @Override
    public TaskSpecFluent.StepsNested<A> editStep(Integer index) {
        if (this.steps.size() <= index) {
            throw new RuntimeException("Can't edit steps. Index exceeds size.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    @Override
    public TaskSpecFluent.StepsNested<A> editFirstStep() {
        if (this.steps.size() == 0) {
            throw new RuntimeException("Can't edit first steps. The list is empty.");
        }
        return this.setNewStepLike(0, this.buildStep(0));
    }

    @Override
    public TaskSpecFluent.StepsNested<A> editLastStep() {
        int index = this.steps.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last steps. The list is empty.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    @Override
    public TaskSpecFluent.StepsNested<A> editMatchingStep(Predicate<StepBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.steps.size(); ++i) {
            if (!predicate.test(this.steps.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching steps. No match found.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    @Override
    public A addToVolumes(Integer index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        this._visitables.get((Object)"volumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"volumes").size(), builder);
        this.volumes.add(index >= 0 ? index.intValue() : this.volumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumes(Integer index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"volumes").size()) {
            this._visitables.get((Object)"volumes").add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
        }
        if (index < 0 || index >= this.volumes.size()) {
            this.volumes.add(builder);
        } else {
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)this;
        }
        Iterator<VolumeBuilder> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            VolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Volume> getVolumes() {
        return this.volumes != null ? TaskSpecFluentImpl.build(this.volumes) : null;
    }

    @Override
    public List<Volume> buildVolumes() {
        return this.volumes != null ? TaskSpecFluentImpl.build(this.volumes) : null;
    }

    @Override
    public Volume buildVolume(Integer index) {
        return this.volumes.get(index).build();
    }

    @Override
    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    @Override
    public Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    @Override
    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public TaskSpecFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public TaskSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(-1, item);
    }

    @Override
    public TaskSpecFluent.VolumesNested<A> setNewVolumeLike(Integer index, Volume item) {
        return new VolumesNestedImpl(index, item);
    }

    @Override
    public TaskSpecFluent.VolumesNested<A> editVolume(Integer index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public TaskSpecFluent.VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    @Override
    public TaskSpecFluent.VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public TaskSpecFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public A addToWorkspaces(Integer index, WorkspaceDeclaration item) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);
        this._visitables.get((Object)"workspaces").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"workspaces").size(), builder);
        this.workspaces.add(index >= 0 ? index.intValue() : this.workspaces.size(), builder);
        return (A)this;
    }

    @Override
    public A setToWorkspaces(Integer index, WorkspaceDeclaration item) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"workspaces").size()) {
            this._visitables.get((Object)"workspaces").add(builder);
        } else {
            this._visitables.get((Object)"workspaces").set(index, builder);
        }
        if (index < 0 || index >= this.workspaces.size()) {
            this.workspaces.add(builder);
        } else {
            this.workspaces.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToWorkspaces(WorkspaceDeclaration ... items) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        for (WorkspaceDeclaration item : items) {
            WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToWorkspaces(Collection<WorkspaceDeclaration> items) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        for (WorkspaceDeclaration item : items) {
            WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromWorkspaces(WorkspaceDeclaration ... items) {
        for (WorkspaceDeclaration item : items) {
            WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);
            this._visitables.get((Object)"workspaces").remove(builder);
            if (this.workspaces == null) continue;
            this.workspaces.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromWorkspaces(Collection<WorkspaceDeclaration> items) {
        for (WorkspaceDeclaration item : items) {
            WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);
            this._visitables.get((Object)"workspaces").remove(builder);
            if (this.workspaces == null) continue;
            this.workspaces.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromWorkspaces(Predicate<WorkspaceDeclarationBuilder> predicate) {
        if (this.workspaces == null) {
            return (A)this;
        }
        Iterator<WorkspaceDeclarationBuilder> each = this.workspaces.iterator();
        List visitables = this._visitables.get((Object)"workspaces");
        while (each.hasNext()) {
            WorkspaceDeclarationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<WorkspaceDeclaration> getWorkspaces() {
        return this.workspaces != null ? TaskSpecFluentImpl.build(this.workspaces) : null;
    }

    @Override
    public List<WorkspaceDeclaration> buildWorkspaces() {
        return this.workspaces != null ? TaskSpecFluentImpl.build(this.workspaces) : null;
    }

    @Override
    public WorkspaceDeclaration buildWorkspace(Integer index) {
        return this.workspaces.get(index).build();
    }

    @Override
    public WorkspaceDeclaration buildFirstWorkspace() {
        return this.workspaces.get(0).build();
    }

    @Override
    public WorkspaceDeclaration buildLastWorkspace() {
        return this.workspaces.get(this.workspaces.size() - 1).build();
    }

    @Override
    public WorkspaceDeclaration buildMatchingWorkspace(Predicate<WorkspaceDeclarationBuilder> predicate) {
        for (WorkspaceDeclarationBuilder item : this.workspaces) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingWorkspace(Predicate<WorkspaceDeclarationBuilder> predicate) {
        for (WorkspaceDeclarationBuilder item : this.workspaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withWorkspaces(List<WorkspaceDeclaration> workspaces) {
        if (this.workspaces != null) {
            this._visitables.get((Object)"workspaces").removeAll(this.workspaces);
        }
        if (workspaces != null) {
            this.workspaces = new ArrayList();
            for (WorkspaceDeclaration item : workspaces) {
                this.addToWorkspaces(item);
            }
        } else {
            this.workspaces = null;
        }
        return (A)this;
    }

    @Override
    public A withWorkspaces(WorkspaceDeclaration ... workspaces) {
        if (this.workspaces != null) {
            this.workspaces.clear();
        }
        if (workspaces != null) {
            for (WorkspaceDeclaration item : workspaces) {
                this.addToWorkspaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasWorkspaces() {
        return this.workspaces != null && !this.workspaces.isEmpty();
    }

    @Override
    public A addNewWorkspace(String description, String mountPath, String name, Boolean readOnly) {
        return this.addToWorkspaces(new WorkspaceDeclaration(description, mountPath, name, readOnly));
    }

    @Override
    public TaskSpecFluent.WorkspacesNested<A> addNewWorkspace() {
        return new WorkspacesNestedImpl();
    }

    @Override
    public TaskSpecFluent.WorkspacesNested<A> addNewWorkspaceLike(WorkspaceDeclaration item) {
        return new WorkspacesNestedImpl(-1, item);
    }

    @Override
    public TaskSpecFluent.WorkspacesNested<A> setNewWorkspaceLike(Integer index, WorkspaceDeclaration item) {
        return new WorkspacesNestedImpl(index, item);
    }

    @Override
    public TaskSpecFluent.WorkspacesNested<A> editWorkspace(Integer index) {
        if (this.workspaces.size() <= index) {
            throw new RuntimeException("Can't edit workspaces. Index exceeds size.");
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    @Override
    public TaskSpecFluent.WorkspacesNested<A> editFirstWorkspace() {
        if (this.workspaces.size() == 0) {
            throw new RuntimeException("Can't edit first workspaces. The list is empty.");
        }
        return this.setNewWorkspaceLike(0, this.buildWorkspace(0));
    }

    @Override
    public TaskSpecFluent.WorkspacesNested<A> editLastWorkspace() {
        int index = this.workspaces.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last workspaces. The list is empty.");
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    @Override
    public TaskSpecFluent.WorkspacesNested<A> editMatchingWorkspace(Predicate<WorkspaceDeclarationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.workspaces.size(); ++i) {
            if (!predicate.test(this.workspaces.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching workspaces. No match found.");
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskSpecFluentImpl that = (TaskSpecFluentImpl)o;
        if (this.inputs != null ? !this.inputs.equals(that.inputs) : that.inputs != null) {
            return false;
        }
        if (this.outputs != null ? !this.outputs.equals(that.outputs) : that.outputs != null) {
            return false;
        }
        if (this.results != null ? !this.results.equals(that.results) : that.results != null) {
            return false;
        }
        if (this.sidecars != null ? !this.sidecars.equals(that.sidecars) : that.sidecars != null) {
            return false;
        }
        if (this.stepTemplate != null ? !this.stepTemplate.equals((Object)that.stepTemplate) : that.stepTemplate != null) {
            return false;
        }
        if (this.steps != null ? !this.steps.equals(that.steps) : that.steps != null) {
            return false;
        }
        if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) {
            return false;
        }
        return !(this.workspaces != null ? !this.workspaces.equals(that.workspaces) : that.workspaces != null);
    }

    public int hashCode() {
        return Objects.hash(this.inputs, this.outputs, this.results, this.sidecars, this.stepTemplate, this.steps, this.volumes, this.workspaces, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.inputs != null) {
            sb.append("inputs:");
            sb.append(this.inputs + ",");
        }
        if (this.outputs != null) {
            sb.append("outputs:");
            sb.append(this.outputs + ",");
        }
        if (this.results != null && !this.results.isEmpty()) {
            sb.append("results:");
            sb.append(this.results + ",");
        }
        if (this.sidecars != null && !this.sidecars.isEmpty()) {
            sb.append("sidecars:");
            sb.append(this.sidecars + ",");
        }
        if (this.stepTemplate != null) {
            sb.append("stepTemplate:");
            sb.append(this.stepTemplate + ",");
        }
        if (this.steps != null && !this.steps.isEmpty()) {
            sb.append("steps:");
            sb.append(this.steps + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes + ",");
        }
        if (this.workspaces != null && !this.workspaces.isEmpty()) {
            sb.append("workspaces:");
            sb.append(this.workspaces);
        }
        sb.append("}");
        return sb.toString();
    }

    class WorkspacesNestedImpl<N>
    extends WorkspaceDeclarationFluentImpl<TaskSpecFluent.WorkspacesNested<N>>
    implements TaskSpecFluent.WorkspacesNested<N>,
    Nested<N> {
        WorkspaceDeclarationBuilder builder;
        Integer index;

        WorkspacesNestedImpl(Integer index, WorkspaceDeclaration item) {
            this.index = index;
            this.builder = new WorkspaceDeclarationBuilder(this, item);
        }

        WorkspacesNestedImpl() {
            this.index = -1;
            this.builder = new WorkspaceDeclarationBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.setToWorkspaces(this.index, this.builder.build());
        }

        @Override
        public N endWorkspace() {
            return this.and();
        }
    }

    class VolumesNestedImpl<N>
    extends VolumeFluentImpl<TaskSpecFluent.VolumesNested<N>>
    implements TaskSpecFluent.VolumesNested<N>,
    Nested<N> {
        VolumeBuilder builder;
        Integer index;

        VolumesNestedImpl(Integer index, Volume item) {
            this.index = index;
            this.builder = new VolumeBuilder((VolumeFluent)this, item);
        }

        VolumesNestedImpl() {
            this.index = -1;
            this.builder = new VolumeBuilder((VolumeFluent)this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.setToVolumes(this.index, this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }

    class StepsNestedImpl<N>
    extends StepFluentImpl<TaskSpecFluent.StepsNested<N>>
    implements TaskSpecFluent.StepsNested<N>,
    Nested<N> {
        StepBuilder builder;
        Integer index;

        StepsNestedImpl(Integer index, Step item) {
            this.index = index;
            this.builder = new StepBuilder(this, item);
        }

        StepsNestedImpl() {
            this.index = -1;
            this.builder = new StepBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.setToSteps(this.index, this.builder.build());
        }

        @Override
        public N endStep() {
            return this.and();
        }
    }

    class StepTemplateNestedImpl<N>
    extends ContainerFluentImpl<TaskSpecFluent.StepTemplateNested<N>>
    implements TaskSpecFluent.StepTemplateNested<N>,
    Nested<N> {
        ContainerBuilder builder;

        StepTemplateNestedImpl(Container item) {
            this.builder = new ContainerBuilder((ContainerFluent)this, item);
        }

        StepTemplateNestedImpl() {
            this.builder = new ContainerBuilder((ContainerFluent)this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.withStepTemplate(this.builder.build());
        }

        @Override
        public N endStepTemplate() {
            return this.and();
        }
    }

    class SidecarsNestedImpl<N>
    extends ContainerFluentImpl<TaskSpecFluent.SidecarsNested<N>>
    implements TaskSpecFluent.SidecarsNested<N>,
    Nested<N> {
        ContainerBuilder builder;
        Integer index;

        SidecarsNestedImpl(Integer index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder((ContainerFluent)this, item);
        }

        SidecarsNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder((ContainerFluent)this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.setToSidecars(this.index, this.builder.build());
        }

        @Override
        public N endSidecar() {
            return this.and();
        }
    }

    class ResultsNestedImpl<N>
    extends TaskResultFluentImpl<TaskSpecFluent.ResultsNested<N>>
    implements TaskSpecFluent.ResultsNested<N>,
    Nested<N> {
        TaskResultBuilder builder;
        Integer index;

        ResultsNestedImpl(Integer index, TaskResult item) {
            this.index = index;
            this.builder = new TaskResultBuilder(this, item);
        }

        ResultsNestedImpl() {
            this.index = -1;
            this.builder = new TaskResultBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.setToResults(this.index, this.builder.build());
        }

        @Override
        public N endResult() {
            return this.and();
        }
    }

    class OutputsNestedImpl<N>
    extends OutputsFluentImpl<TaskSpecFluent.OutputsNested<N>>
    implements TaskSpecFluent.OutputsNested<N>,
    Nested<N> {
        OutputsBuilder builder;

        OutputsNestedImpl(Outputs item) {
            this.builder = new OutputsBuilder(this, item);
        }

        OutputsNestedImpl() {
            this.builder = new OutputsBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.withOutputs(this.builder.build());
        }

        @Override
        public N endOutputs() {
            return this.and();
        }
    }

    class InputsNestedImpl<N>
    extends InputsFluentImpl<TaskSpecFluent.InputsNested<N>>
    implements TaskSpecFluent.InputsNested<N>,
    Nested<N> {
        InputsBuilder builder;

        InputsNestedImpl(Inputs item) {
            this.builder = new InputsBuilder(this, item);
        }

        InputsNestedImpl() {
            this.builder = new InputsBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.withInputs(this.builder.build());
        }

        @Override
        public N endInputs() {
            return this.and();
        }
    }
}

