/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.components.impl;

import io.fabric8.vertx.maven.plugin.components.ManifestCustomizerService;
import io.fabric8.vertx.maven.plugin.mojos.PackageMojo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ManifestCustomizerService.class, hint="project")
public class ProjectManifestCustomizer
implements ManifestCustomizerService {
    private static String DEFAULT_DATE_PATTERN = "yyyyMMdd HH:mm:ss z";
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DEFAULT_DATE_PATTERN);

    @Override
    public Map<String, String> getEntries(PackageMojo mojo, MavenProject project) {
        List dependencies;
        HashMap<String, String> attributes = new HashMap<String, String>();
        Model model = project.getModel();
        attributes.put("Project-Name", model.getName() == null ? model.getArtifactId() : model.getName());
        attributes.put("Project-Group", model.getGroupId());
        attributes.put("Project-Version", model.getVersion());
        attributes.put("Build-Timestamp", ProjectManifestCustomizer.manifestTimestampFormat(new Date()));
        if (project.getUrl() != null) {
            attributes.put("Project-Url", model.getUrl());
        }
        if ((dependencies = model.getDependencies()) != null && !dependencies.isEmpty()) {
            String deps = dependencies.stream().filter(d -> "compile".equals(d.getScope()) || null == d.getScope()).map(ProjectManifestCustomizer::asCoordinates).collect(Collectors.joining(" "));
            attributes.put("Project-Dependencies", deps);
        }
        return attributes;
    }

    public static String manifestTimestampFormat(Date date) {
        return simpleDateFormat.format(date);
    }

    private static String asCoordinates(Dependency dependency) {
        StringBuilder dependencyCoordinates = new StringBuilder().append(dependency.getGroupId()).append(":").append(dependency.getArtifactId()).append(":").append(dependency.getVersion());
        if (dependency.getClassifier() != null) {
            dependencyCoordinates.append(":").append(dependency.getClassifier());
        }
        return dependencyCoordinates.toString();
    }
}

