/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.dependencies;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.maven.model.Dependency;

public class VertxDependency {
    private String artifactId;
    private String groupId;
    private String scope;
    private String type;
    private String classifier;
    private String name;
    private String[] labels;

    public String getArtifactId() {
        return this.artifactId;
    }

    public VertxDependency setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public VertxDependency setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public VertxDependency setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public VertxDependency setType(String type) {
        this.type = type;
        return this;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public VertxDependency setClassifier(String classifier) {
        this.classifier = classifier;
        return this;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public VertxDependency setLabels(String[] labels) {
        this.labels = labels;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public VertxDependency setName(String name) {
        this.name = name;
        return this;
    }

    public List<String> labels() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.labels != null) {
            Stream.of(this.labels).map(String::toLowerCase).forEach(list::add);
        }
        list.add(this.artifactId.toLowerCase());
        return list;
    }

    public Dependency toDependency() {
        Dependency dependency = new Dependency();
        dependency.setGroupId(this.groupId);
        dependency.setArtifactId(this.artifactId);
        if (this.scope != null && !this.scope.isEmpty()) {
            dependency.setScope(this.scope);
        }
        if (this.classifier != null && !this.classifier.isEmpty()) {
            dependency.setClassifier(this.classifier);
        }
        return dependency;
    }

    public String toCoordinates() {
        return this.getGroupId() + ":" + this.getArtifactId();
    }
}

