/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.mojos;

import io.fabric8.vertx.maven.plugin.mojos.AbstractRunMojo;
import io.fabric8.vertx.maven.plugin.mojos.PackageMojo;
import io.fabric8.vertx.maven.plugin.utils.MavenExecutionUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="start", threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class StartMojo
extends AbstractRunMojo {
    @Parameter(alias="mode", property="vertx.start.mode", defaultValue="jar")
    protected String runMode;
    @Parameter(alias="appId", property="vertx.app.id")
    protected String appId;
    @Parameter(name="classifier")
    protected String classifier;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"vertx:start skipped by configuration");
            return;
        }
        this.vertxCommand = "start";
        String vertxProcId = this.getAppId();
        this.scanAndLoadConfigs();
        ArrayList<String> argsList = new ArrayList<String>();
        try {
            Path pidFilePath = Paths.get(this.workDirectory.toString(), "vertx-start-process.id");
            if (pidFilePath.toFile().exists() && pidFilePath.toFile().isFile()) {
                Files.delete(pidFilePath);
            }
            Files.write(Paths.get(this.workDirectory.toString(), "vertx-start-process.id"), vertxProcId.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write process file to directory :" + this.workDirectory.toString());
        }
        boolean jarMode = "jar".equals(this.runMode);
        if (jarMode) {
            String name = PackageMojo.computeOutputName(this.project, this.classifier);
            File fatjar = new File(this.project.getBuild().getDirectory(), name);
            if (!fatjar.isFile()) {
                this.getLog().warn((CharSequence)"Unable to find the Vert.x application jar, triggering the build");
                MavenExecutionUtils.execute("package", this.project, this.mavenSession, this.lifecycleExecutor, this.container);
            }
            if (fatjar.isFile() && this.isVertxLauncher(this.launcher)) {
                argsList.add("-jar");
                argsList.add(fatjar.getAbsolutePath());
            } else {
                if (!fatjar.isFile() || this.isVertxLauncher(this.launcher)) throw new MojoFailureException("Unable to find vertx application jar --> " + fatjar.getAbsolutePath());
                argsList.add("-cp");
                argsList.add(fatjar.getAbsolutePath());
                argsList.add("io.vertx.core.Launcher");
            }
        } else {
            this.addClasspath(argsList);
            if (this.isVertxLauncher(this.launcher)) {
                argsList.add(this.launcher);
            } else {
                argsList.add("io.vertx.core.Launcher");
            }
        }
        argsList.add(this.vertxCommand);
        if (!jarMode) {
            argsList.add(this.verticle);
        }
        if (this.config != null && this.config.exists() && this.config.isFile()) {
            this.getLog().info((CharSequence)("Using configuration from file: " + this.config.toString()));
            argsList.add("-conf");
            argsList.add(this.config.toString());
        }
        if (this.launcher != null && !this.isVertxLauncher(this.launcher)) {
            argsList.add("--launcher-class");
            argsList.add(this.launcher);
        }
        argsList.add("-id");
        argsList.add(vertxProcId);
        if (this.jvmArgs != null && !this.jvmArgs.isEmpty()) {
            String javaOpts = this.jvmArgs.stream().collect(Collectors.joining(" "));
            String argJavaOpts = "--java-opts=" + javaOpts;
            argsList.add(argJavaOpts);
        }
        this.run(argsList);
    }

    private String getAppId() {
        if (this.appId == null) {
            UUID uuid = UUID.randomUUID();
            this.appId = uuid.toString();
        }
        return this.appId;
    }
}

