/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.stream.Collectors;

public class FileUtils {
    public static Path backup(File source, File backupDir) throws IOException {
        Path sourceFilePath = Paths.get(source.toURI());
        String targetName = org.codehaus.plexus.util.FileUtils.basename((String)source.toString()) + "original.jar";
        Path backupFilePath = Paths.get(backupDir.toURI().resolve(targetName));
        if (backupDir.isDirectory()) {
            Files.move(sourceFilePath, Paths.get(backupDir.toString(), targetName), StandardCopyOption.ATOMIC_MOVE);
        }
        return backupFilePath;
    }

    public static Path copy(File source, File destDir) throws IOException {
        Path sourceFilePath = Paths.get(source.toURI());
        String targetName = org.codehaus.plexus.util.FileUtils.basename((String)source.toString()) + "original.jar";
        Path backupFilePath = Paths.get(destDir.toURI().resolve(targetName));
        if (destDir.exists() && destDir.isDirectory()) {
            Files.copy(sourceFilePath, Paths.get(destDir.toString(), targetName), StandardCopyOption.REPLACE_EXISTING);
        }
        return backupFilePath;
    }

    public static String read(InputStream input) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input));){
            String string = buffer.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }
}

