/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.vertx.maven.plugin.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class MojoUtils {
    private static final String RESOURCES_PLUGIN_KEY = "org.apache.maven.plugins:maven-resources-plugin";
    private static final String G_MAVEN_RESOURCES_PLUGIN = "org.apache.maven.plugins";
    private static final String A_MAVEN_RESOURCES_PLUGIN = "maven-resources-plugin";
    private static final String V_MAVEN_RESOURCES_PLUGIN = "maven-resources-plugin-version";
    private static final String G_MAVEN_COMPILER_PLUGIN = "org.apache.maven.plugins";
    private static final String A_MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin";
    private static final String V_MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin-version";
    private static final String GOAL_COMPILE = "compile";
    private static final String GOAL_RESOURCES = "resources";
    private static final Properties properties = new Properties();

    private MojoUtils() {
    }

    public static void copyResources(MavenProject project, MavenSession mavenSession, BuildPluginManager buildPluginManager) throws MojoExecutionException {
        Optional<Plugin> resourcesPlugin = MojoUtils.hasPlugin(project, RESOURCES_PLUGIN_KEY);
        Xpp3Dom pluginConfig = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"outputDirectory", (String)"${project.build.outputDirectory}")});
        if (resourcesPlugin.isPresent()) {
            Optional<Xpp3Dom> optConfiguration = MojoUtils.buildConfiguration(project, A_MAVEN_RESOURCES_PLUGIN, GOAL_RESOURCES);
            if (optConfiguration.isPresent()) {
                pluginConfig = optConfiguration.get();
            }
            MojoExecutor.executeMojo((Plugin)resourcesPlugin.get(), (String)MojoExecutor.goal((String)GOAL_RESOURCES), (Xpp3Dom)pluginConfig, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)project, (MavenSession)mavenSession, (BuildPluginManager)buildPluginManager));
        } else {
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)"org.apache.maven.plugins", (String)A_MAVEN_RESOURCES_PLUGIN, (String)properties.getProperty(V_MAVEN_RESOURCES_PLUGIN)), (String)MojoExecutor.goal((String)GOAL_RESOURCES), (Xpp3Dom)pluginConfig, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)project, (MavenSession)mavenSession, (BuildPluginManager)buildPluginManager));
        }
    }

    public static Optional<Plugin> hasPlugin(MavenProject project, String pluginKey) {
        Optional<Plugin> optPlugin = project.getBuildPlugins().stream().filter(plugin -> pluginKey.equals(plugin.getKey())).findFirst();
        if (!optPlugin.isPresent() && project.getPluginManagement() != null) {
            optPlugin = project.getPluginManagement().getPlugins().stream().filter(plugin -> pluginKey.equals(plugin.getKey())).findFirst();
        }
        return optPlugin;
    }

    public static boolean hasDependency(MavenProject project, String groupId, String artifactId) {
        Optional<Dependency> dep = project.getDependencies().stream().filter(d -> groupId.equals(d.getGroupId()) && artifactId.equals(d.getArtifactId())).findFirst();
        return dep.isPresent();
    }

    public static void compile(MavenProject project, MavenSession mavenSession, BuildPluginManager buildPluginManager) throws Exception {
        Optional<Xpp3Dom> optConfiguration;
        Optional<Plugin> mvnCompilerPlugin = project.getBuildPlugins().stream().filter(plugin -> A_MAVEN_COMPILER_PLUGIN.equals(plugin.getArtifactId())).findFirst();
        String pluginVersion = properties.getProperty(V_MAVEN_COMPILER_PLUGIN);
        if (mvnCompilerPlugin.isPresent()) {
            pluginVersion = mvnCompilerPlugin.get().getVersion();
        }
        if ((optConfiguration = MojoUtils.buildConfiguration(project, A_MAVEN_COMPILER_PLUGIN, GOAL_COMPILE)).isPresent()) {
            Xpp3Dom configuration = optConfiguration.get();
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)"org.apache.maven.plugins", (String)A_MAVEN_COMPILER_PLUGIN, (String)pluginVersion), (String)MojoExecutor.goal((String)GOAL_COMPILE), (Xpp3Dom)configuration, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)project, (MavenSession)mavenSession, (BuildPluginManager)buildPluginManager));
        }
    }

    private static List<String> goals(Object goals) {
        if (goals instanceof List) {
            return (List)goals;
        }
        return null;
    }

    public static Optional<Xpp3Dom> buildConfiguration(MavenProject project, String artifactId, String goal) {
        Plugin plugin2;
        Optional<Plugin> pluginOptional = project.getBuildPlugins().stream().filter(plugin -> artifactId.equals(plugin.getArtifactId())).findFirst();
        if (pluginOptional.isPresent()) {
            plugin2 = pluginOptional.get();
            List<String> goals = MojoUtils.goals(plugin2.getGoals());
            if (goals != null && goals.contains(goal)) {
                return Optional.ofNullable((Xpp3Dom)plugin2.getConfiguration());
            }
        } else {
            return Optional.empty();
        }
        Optional<PluginExecution> executionOptional = plugin2.getExecutions().stream().filter(e -> e.getGoals().contains(goal)).findFirst();
        executionOptional.ifPresent(pluginExecution -> Optional.ofNullable((Xpp3Dom)pluginExecution.getConfiguration()));
        return Optional.ofNullable((Xpp3Dom)plugin2.getConfiguration());
    }

    private static void loadProperties() {
        URL url = MojoUtils.class.getClassLoader().getResource("vertx-maven-plugin.properties");
        Objects.requireNonNull(url);
        try (InputStream in = url.openStream();){
            properties.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Invalid packaging of the vertx-maven-plugin, the vertx-maven-plugin.properties file cannot be read", e);
        }
    }

    public static String getVersion(String key) {
        return properties.getProperty(key);
    }

    static {
        MojoUtils.loadProperties();
    }
}

